/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate;

import com.meidusa.venus.validate.ASMClassLoader;
import com.meidusa.venus.validate.AsmValidatorClassInfo;
import com.meidusa.venus.validate.AsmValidatorContext;
import com.meidusa.venus.validate.AsmValidatorFieldInfo;
import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.expression.PolicyExpression;
import com.meidusa.venus.validate.validator.AsmValidatorSupport;
import com.meidusa.venus.validate.validator.Validator;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AsmVisitorValidatorFactory {
    private AtomicInteger markClassName = new AtomicInteger();
    private final String SUPER_CLASS = this.getType(AsmValidatorSupport.class);
    private ASMClassLoader classLoader = new ASMClassLoader();
    private Map<Class<?>, Method> annotationMethod = new HashMap();

    private String getPrimitiveLetter(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return "I";
        }
        if (Void.TYPE.equals(type)) {
            return "V";
        }
        if (Boolean.TYPE.equals(type)) {
            return "Z";
        }
        if (Character.TYPE.equals(type)) {
            return "C";
        }
        if (Byte.TYPE.equals(type)) {
            return "B";
        }
        if (Short.TYPE.equals(type)) {
            return "S";
        }
        if (Float.TYPE.equals(type)) {
            return "F";
        }
        if (Long.TYPE.equals(type)) {
            return "J";
        }
        if (Double.TYPE.equals(type)) {
            return "D";
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    public String getType(Class<?> type) {
        if (type.isArray()) {
            return "[" + this.getDesc(type.getComponentType());
        }
        if (!type.isPrimitive()) {
            String clsName = type.getCanonicalName();
            if (type.isMemberClass()) {
                int lastDot = clsName.lastIndexOf(".");
                clsName = clsName.substring(0, lastDot) + "$" + clsName.substring(lastDot + 1);
            }
            return clsName.replaceAll("\\.", "/");
        }
        return this.getPrimitiveLetter(type);
    }

    public String getDesc(Class<?> type) {
        if (type.isPrimitive()) {
            return this.getPrimitiveLetter(type);
        }
        if (type.isArray()) {
            return "[" + this.getDesc(type.getComponentType());
        }
        return "L" + this.getType(type) + ";";
    }

    private String constructMethodDesc(Class<?> returnType, Class<?> ... paramType) {
        StringBuilder methodDesc = new StringBuilder();
        methodDesc.append('(');
        for (int i = 0; i < paramType.length; ++i) {
            methodDesc.append(this.getDesc(paramType[i]));
        }
        methodDesc.append(')');
        if (returnType == Void.class) {
            methodDesc.append("V");
        } else {
            methodDesc.append(this.getDesc(returnType));
        }
        return methodDesc.toString();
    }

    private String generateClassName(Class<?> clazz) {
        String className = clazz.getCanonicalName();
        className = className.replace('.', '_');
        className = className + "_validator_generated_" + this.markClassName.getAndIncrement();
        return className;
    }

    public Validator createAsmVistorValidator(String policy, Class<?> clazz, String fieldName) {
        Class<? extends AsmValidatorSupport> validatorClazz = null;
        validatorClazz = this.createAsmVistorValidatorClassInternal(policy, clazz);
        AsmValidatorSupport asmValidator = null;
        try {
            asmValidator = validatorClazz.newInstance();
            asmValidator.setFieldName(fieldName);
            return asmValidator;
        }
        catch (Exception e) {
            throw new RuntimeException("cannot init validator ", e);
        }
    }

    private Class<? extends AsmValidatorSupport> createAsmVistorValidatorClassInternal(String policy, Class<?> clazz) {
        ClassWriter clsWriter = new ClassWriter(1);
        AsmValidatorContext context = this.buildContext(policy, clazz);
        clsWriter.visit(49, 33, context.getValidatorClassName(), "null", this.SUPER_CLASS, null);
        this.writeField(clsWriter, context);
        this.writeInit(clsWriter, context);
        this.writeValidate(clsWriter, context);
        byte[] code = clsWriter.toByteArray();
        Class<?> exampleClass = this.classLoader.defineClassPublic(context.getValidatorClassName(), code, 0, code.length);
        return exampleClass;
    }

    private AsmValidatorContext buildContext(String policy, Class<?> clazz) {
        AsmValidatorContext context = new AsmValidatorContext();
        context.setVistorClass(clazz);
        context.setClassInfoList(this.generateClassInfos(policy, clazz));
        context.setFieldInfoList(this.generateFieldInfos(policy, clazz));
        context.setValidatorClassName(this.generateClassName(clazz));
        return context;
    }

    private List<AsmValidatorClassInfo> generateClassInfos(String policy, Class<?> clazz) {
        ArrayList<AsmValidatorClassInfo> classInfoList = new ArrayList<AsmValidatorClassInfo>();
        for (Class<?> superClazz = clazz; superClazz != Object.class; superClazz = superClazz.getSuperclass()) {
            Annotation[] annotations = superClazz.getAnnotations();
            for (int i = 0; i < annotations.length; ++i) {
                com.meidusa.venus.validate.validator.annotation.Validator validatorFactory = annotations[i].annotationType().getAnnotation(com.meidusa.venus.validate.validator.annotation.Validator.class);
                if (validatorFactory == null) continue;
                AsmValidatorClassInfo classInfo = new AsmValidatorClassInfo();
                classInfo.setAnnotionOrder(i);
                classInfo.setClazz(superClazz);
                classInfo.setValidatorFieldName(this.getClassValidatorName(classInfo));
                String annotationPolicy = this.invokePolicy(annotations[i]);
                if (!PolicyExpression.match(policy, annotationPolicy)) continue;
                classInfoList.add(classInfo);
            }
        }
        return classInfoList;
    }

    private String invokePolicy(Object obj) {
        try {
            Method method = this.annotationMethod.get(obj.getClass());
            if (method == null) {
                method = obj.getClass().getMethod("policy", new Class[0]);
                this.annotationMethod.put(((Annotation)obj).annotationType(), method);
            }
            return (String)method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            return "";
        }
    }

    private List<AsmValidatorFieldInfo> generateFieldInfos(String policy, Class<?> clazz) {
        ArrayList<AsmValidatorFieldInfo> fieldInfoList = new ArrayList<AsmValidatorFieldInfo>();
        for (Class<?> superClazz = clazz; superClazz != Object.class; superClazz = superClazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = superClazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                Method fieldGetMethod = null;
                try {
                    PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
                    fieldGetMethod = pd.getReadMethod();
                }
                catch (IntrospectionException e) {
                    // empty catch block
                }
                Annotation[] annotations = field.getAnnotations();
                for (int i = 0; i < annotations.length; ++i) {
                    com.meidusa.venus.validate.validator.annotation.Validator validatorFactory = annotations[i].annotationType().getAnnotation(com.meidusa.venus.validate.validator.annotation.Validator.class);
                    if (validatorFactory == null || fieldGetMethod == null) continue;
                    AsmValidatorFieldInfo info = new AsmValidatorFieldInfo();
                    info.setAnnotionOrder(i);
                    info.setField(field);
                    info.setGetMethod(fieldGetMethod);
                    info.setValidatorFieldName(this.getFieldValidatorName(info));
                    String annotationPolicy = this.invokePolicy(annotations[i]);
                    if (!PolicyExpression.match(policy, annotationPolicy)) continue;
                    fieldInfoList.add(info);
                }
            }
        }
        return fieldInfoList;
    }

    private void writeField(ClassWriter clsWriter, AsmValidatorContext context) {
        for (AsmValidatorClassInfo classInfo : context.getClassInfoList()) {
            clsWriter.visitField(2, classInfo.getValidatorFieldName(), this.getDesc(Validator.class), "", null);
        }
        for (AsmValidatorFieldInfo fieldInfo : context.getFieldInfoList()) {
            clsWriter.visitField(2, fieldInfo.getValidatorFieldName(), this.getDesc(Validator.class), "", null);
        }
    }

    private String getClassValidatorName(AsmValidatorClassInfo classInfo) {
        return classInfo.getClazz().getCanonicalName().replace('.', '_') + "_visitors_" + classInfo.getAnnotionOrder();
    }

    private String getFieldValidatorName(AsmValidatorFieldInfo fieldInfo) {
        return fieldInfo.getField().getName() + "_visitors_" + fieldInfo.getAnnotionOrder();
    }

    private void writeInit(ClassWriter clsWriter, AsmValidatorContext context) {
        MethodVisitor mw = clsWriter.visitMethod(1, "<init>", this.constructMethodDesc(Void.class, new Class[0]), null, null);
        mw.visitVarInsn(25, 0);
        mw.visitMethodInsn(183, this.getType(AsmValidatorSupport.class), "<init>", this.constructMethodDesc(Void.class, new Class[0]));
        for (AsmValidatorClassInfo classInfo : context.getClassInfoList()) {
            mw.visitVarInsn(25, 0);
            mw.visitVarInsn(25, 0);
            mw.visitLdcInsn((Object)Type.getType(classInfo.getClazz()));
            mw.visitIntInsn(16, classInfo.getAnnotionOrder());
            mw.visitMethodInsn(183, this.getType(AsmValidatorSupport.class), "createFromClass", this.constructMethodDesc(Validator.class, Class.class, Integer.TYPE));
            mw.visitFieldInsn(181, context.getValidatorClassName(), this.getClassValidatorName(classInfo), this.getDesc(Validator.class));
        }
        for (AsmValidatorFieldInfo fieldInfo : context.getFieldInfoList()) {
            mw.visitVarInsn(25, 0);
            mw.visitVarInsn(25, 0);
            mw.visitLdcInsn((Object)Type.getType(fieldInfo.getField().getDeclaringClass()));
            mw.visitLdcInsn((Object)fieldInfo.getField().getName());
            mw.visitIntInsn(16, fieldInfo.getAnnotionOrder());
            mw.visitMethodInsn(183, this.getType(AsmValidatorSupport.class), "createFromField", this.constructMethodDesc(Validator.class, Class.class, String.class, Integer.TYPE));
            mw.visitFieldInsn(181, context.getValidatorClassName(), this.getFieldValidatorName(fieldInfo), this.getDesc(Validator.class));
        }
        mw.visitInsn(177);
        mw.visitMaxs(0, 0);
        mw.visitEnd();
    }

    private void writeValidate(ClassWriter clsWriter, AsmValidatorContext context) {
        MethodVisitor mw = clsWriter.visitMethod(1, "validate", this.constructMethodDesc(Void.class, Object.class), null, new String[]{this.getType(ValidationException.class)});
        mw.visitVarInsn(25, 1);
        mw.visitTypeInsn(192, this.getType(context.getVistorClass()));
        mw.visitVarInsn(58, 2);
        for (AsmValidatorClassInfo classInfo : context.getClassInfoList()) {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, context.getValidatorClassName(), classInfo.getValidatorFieldName(), this.getDesc(Validator.class));
            mw.visitVarInsn(25, 2);
            mw.visitMethodInsn(185, this.getType(Validator.class), "validate", this.constructMethodDesc(Void.class, Object.class));
        }
        for (AsmValidatorFieldInfo fieldInfo : context.getFieldInfoList()) {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, context.getValidatorClassName(), fieldInfo.getValidatorFieldName(), this.getDesc(Validator.class));
            mw.visitVarInsn(25, 2);
            mw.visitMethodInsn(182, this.getType(context.getVistorClass()), fieldInfo.getGetMethod().getName(), this.constructMethodDesc(fieldInfo.getGetMethod().getReturnType(), fieldInfo.getGetMethod().getParameterTypes()));
            if (fieldInfo.getGetMethod().getReturnType().isPrimitive()) {
                this.writePrimitive(mw, fieldInfo.getGetMethod().getReturnType());
            }
            mw.visitMethodInsn(185, this.getType(Validator.class), "validate", this.constructMethodDesc(Void.class, Object.class));
        }
        mw.visitInsn(177);
        mw.visitMaxs(0, 0);
        mw.visitEnd();
    }

    private void writePrimitive(MethodVisitor mw, Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            mw.visitMethodInsn(184, this.getType(Integer.class), "valueOf", this.constructMethodDesc(Integer.class, Integer.TYPE));
        } else if (clazz == Long.TYPE) {
            mw.visitMethodInsn(184, this.getType(Long.class), "valueOf", this.constructMethodDesc(Long.class, Long.TYPE));
        } else if (clazz == Double.TYPE) {
            mw.visitMethodInsn(184, this.getType(Double.class), "valueOf", this.constructMethodDesc(Double.class, Double.TYPE));
        } else if (clazz == Float.TYPE) {
            mw.visitMethodInsn(184, this.getType(Float.class), "valueOf", this.constructMethodDesc(Float.class, Float.TYPE));
        } else if (clazz == Boolean.TYPE) {
            mw.visitMethodInsn(184, this.getType(Boolean.class), "valueOf", this.constructMethodDesc(Boolean.class, Boolean.TYPE));
        } else if (clazz == Byte.TYPE) {
            mw.visitMethodInsn(184, this.getType(Byte.class), "valueOf", this.constructMethodDesc(Byte.class, Byte.TYPE));
        } else if (clazz == Character.TYPE) {
            mw.visitMethodInsn(184, this.getType(Character.class), "valueOf", this.constructMethodDesc(Character.class, Character.TYPE));
        }
    }
}

