/**
 * 
 */
package com.meidusa.venus.monitor.util;

/**
 * @author gaoyong
 *
 */
public class UrlUtil {
	
	private static final String URL_PREFIX = "venus";
	private static final String REMOTE = "remote";
	//private static final String LOCAL = "local";
	
	/**
	 * e.g
	 * venus://remote:192.168.0.1:514 or venus://remote:192.168.0.1 (default 514)
	 * venus://local
	 * @param url
	 * @return
	 */
	public static String parseUrl(String url){
		
		if(startsWithIgnoreCase(url, URL_PREFIX)){
			int beginningOfSlashes = url.indexOf("//");
			String subUrl = url.substring(beginningOfSlashes+2);
			
			if(startsWithIgnoreCase(subUrl,REMOTE)){
				    String server;
				    //String port;
					String hostStuff = subUrl.substring(7);
					int portOfSlash = hostStuff.lastIndexOf(':');
					if(portOfSlash!=-1){
						server = hostStuff.substring(0,portOfSlash);
						//port = hostStuff.substring(portOfSlash+1);
					}
					else{
						server = hostStuff.trim();
					}
					return server;
			}
			
		}
		return "127.0.0.1";
		
	}

	 /**
     * <p>Case insensitive check if a String starts with a specified prefix.</p>
     *
     * <p><code>null</code>s are handled without exceptions. Two <code>null</code>
     * references are considered to be equal. The comparison is case insensitive.</p>
     *
     * <pre>
     * StringUtils.startsWithIgnoreCase(null, null)      = true
     * StringUtils.startsWithIgnoreCase(null, "abcdef")  = false
     * StringUtils.startsWithIgnoreCase("abc", null)     = false
     * StringUtils.startsWithIgnoreCase("abc", "abcdef") = true
     * StringUtils.startsWithIgnoreCase("abc", "ABCDEF") = true
     * </pre>
     *
     * @see java.lang.String#startsWith(String)
     * @param str  the String to check, may be null
     * @param prefix the prefix to find, may be null
     * @return <code>true</code> if the String starts with the prefix, case insensitive, or
     *  both <code>null</code>
     * @since 2.4
     */
    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return startsWith(str, prefix, true);
    }
	
	 /**
     * <p>Check if a String starts with a specified prefix (optionally case insensitive).</p>
     *
     * @see java.lang.String#startsWith(String)
     * @param str  the String to check, may be null
     * @param prefix the prefix to find, may be null
     * @param ignoreCase inidicates whether the compare should ignore case
     *  (case insensitive) or not.
     * @return <code>true</code> if the String starts with the prefix or
     *  both <code>null</code>
     */
    private static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return (str == null && prefix == null);
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }
	
}
