/**
 * 
 */
package com.meidusa.venus.monitor.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

/**
 * @author gaoyong
 *
 */
public class IpUtil {
	
	private static InetAddress getFirstNonLoopbackAddress() throws SocketException {
	    Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
	    while (en.hasMoreElements()) {
	        NetworkInterface i = (NetworkInterface) en.nextElement();
	        for (Enumeration<InetAddress> en2 = i.getInetAddresses(); en2.hasMoreElements();) {
	            InetAddress addr = (InetAddress) en2.nextElement();
	            if (!addr.isLoopbackAddress()) {
	                if (addr instanceof Inet4Address) {
	                    return addr;
	                }
	            }
	        }
	    }
	    return null;
	}
	
	public static String getLocalServerIp() {
		InetAddress ip;
		try {
			ip = getFirstNonLoopbackAddress();
		} catch (SocketException e) {
			return "127.0.0.1";
		}
		return ip.getHostAddress();
	}
	
	public static void main(String args[]){
		System.out.println(IpUtil.getLocalServerIp());
	}

}
