/**
 * 
 */
package com.meidusa.venus.monitor.runnable;

import com.meidusa.venus.monitor.Monitor;
import com.meidusa.venus.monitor.event.Event;
import com.meidusa.venus.monitor.model.MonitorContext;
import com.meidusa.venus.monitor.model.MonitorKey;
import com.meidusa.venus.monitor.model.MonitorType;
import com.meidusa.venus.monitor.model.PerformanceMonitorData;

/**
 * @author gaoyong
 *
 */
public class PerformanceCheck extends MonitorCheckTemplate {

	@Override
	boolean isRightMonitorType(MonitorKey key) {
		return key.getMonitorType().equals(MonitorType.PERFORMANCE);
	}

	@Override
	void doMonitorCheck(Monitor monitor) {
		MonitorContext context = monitor.getMonitorContext();
		PerformanceMonitorData data = (PerformanceMonitorData) monitor.getMonitorData();
		if(data.countAvg()>PerformanceMonitorData.latencyThreshold){
			monitor.processEvent(new Event(Event.AVG,context));
		}
		if(data.getConcurrentRequest().intValue() > 5){
			monitor.processEvent(new Event(Event.CONCURRENT,context));
		}
		data.reset();
	}

}
