/**
 * 
 */
package com.meidusa.venus.monitor.runnable;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import com.meidusa.venus.monitor.Monitor;
import com.meidusa.venus.monitor.MonitorManager;
import com.meidusa.venus.monitor.model.MonitorKey;

/**
 * @author gaoyong
 *
 */
public abstract class MonitorCheckTemplate implements Runnable{
	
	@Override
	public void run() {
		Set<Entry<MonitorKey, Monitor>> monitors = MonitorManager.getMonitors().entrySet();
		Iterator<Entry<MonitorKey, Monitor>> iterator = monitors.iterator();
		while(iterator.hasNext()){
			Map.Entry<MonitorKey, Monitor> entry = (Map.Entry<MonitorKey, Monitor>) iterator.next();
			MonitorKey key = entry.getKey();
			if(isRightMonitorType(key)){
				doMonitorCheck(entry.getValue());
			}
		}
		
	}
	
	abstract boolean isRightMonitorType(MonitorKey key);
	
	abstract void doMonitorCheck(Monitor monitor);

}
