/**
 * 
 */
package com.meidusa.venus.monitor.runnable;

import com.meidusa.venus.monitor.Monitor;
import com.meidusa.venus.monitor.event.Event;
import com.meidusa.venus.monitor.model.ExceptionMonitorData;
import com.meidusa.venus.monitor.model.MonitorContext;
import com.meidusa.venus.monitor.model.MonitorKey;
import com.meidusa.venus.monitor.model.MonitorType;

/**
 * @author gaoyong
 *
 */
public class ExceptionCheck extends MonitorCheckTemplate {

	@Override
	boolean isRightMonitorType(MonitorKey key) {
		return key.getMonitorType().equals(MonitorType.EXCEPTION);
	}

	@Override
	void doMonitorCheck(Monitor monitor) {
		MonitorContext context = monitor.getMonitorContext();
		ExceptionMonitorData data = (ExceptionMonitorData) monitor.getMonitorData();
		if(!data.getExceptions().isEmpty()){
			Event event = new Event(Event.EXCEPTION,context);
			monitor.processEvent(event);
			data.reset();
		}
		
	}

}
