/**
 * 
 */
package com.meidusa.venus.monitor.model;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author gaoyong
 *
 */
public class PerformanceMonitorData implements MonitorData{
	
	public static int latencyThreshold = 500;//default 500ms
	public static int frequencyThreshold = 1000;//default 1000 hits a cycle
	
	private AtomicInteger concurrentRequest = new AtomicInteger();
	
	private long totalInterval = 0;
	
	private long averageInterval = 0;
	
	private int invokeTimes = 0;

	public AtomicInteger getConcurrentRequest() {
		return concurrentRequest;
	}

	public void setConcurrentRequest(AtomicInteger concurrentRequest) {
		this.concurrentRequest = concurrentRequest;
	}

	public long getTotalInterval() {
		return totalInterval;
	}

	public void setTotalInterval(long totalInterval) {
		this.totalInterval = totalInterval;
	}

	public int getInvokeTimes() {
		return invokeTimes;
	}

	public void setInvokeTimes(int invokeTimes) {
		this.invokeTimes = invokeTimes;
	}

	public long getAverageInterval() {
		return averageInterval;
	}

	public void setAverageInterval(long averageInterval) {
		this.averageInterval = averageInterval;
	}
	
	public synchronized void setData(long startTime){
		long interval = System.currentTimeMillis()-startTime;
		setInvokeTimes(invokeTimes+1);
		setTotalInterval(totalInterval+interval);
	}
	
	public synchronized long countAvg(){
		if(invokeTimes == 0){
			return 0;
		}
		averageInterval = totalInterval/invokeTimes;
		return averageInterval;
	}

	@Override
	public synchronized void reset() {
		invokeTimes = 0;
		totalInterval = 0;
		averageInterval = 0;
	}
	
	
	
}
