/**
 * 
 */
package com.meidusa.venus.monitor.model;

import java.util.concurrent.ConcurrentHashMap;

/**
 * @author gaoyong
 *
 */
public class ExceptionMonitorData implements MonitorData {
	
	private ConcurrentHashMap<Integer,ExceptionInfo> exceptions = new ConcurrentHashMap<Integer, ExceptionInfo>();

	public ConcurrentHashMap<Integer, ExceptionInfo> getExceptions() {
		return exceptions;
	}
	public void addException(ExceptionInfo exceptionInfo){
		int errorCode = exceptionInfo.getErrorCode();
		if(exceptions.containsKey(errorCode)){
			exceptionInfo = exceptions.get(errorCode);
		}
		else{
			exceptions.put(errorCode, exceptionInfo);
		}
		exceptionInfo.getOccurs().incrementAndGet();
	}
	@Override
	public void reset() {
		exceptions.clear();	
	}

}
