/**
 * 
 */
package com.meidusa.venus.monitor.message;

import com.thoughtworks.xstream.XStream;

/**
 * @author gaoyong
 * 
 */
public class ExceptionMessage extends MonitorMessage {

	String params;
	int errorcode;
	String errordesc;

	public String getParams() {
		return params;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public int getErrorcode() {
		return errorcode;
	}

	public void setErrorcode(int errorcode) {
		this.errorcode = errorcode;
	}

	public String getErrordesc() {
		return errordesc;
	}

	public void setErrordesc(String errordesc) {
		this.errordesc = errordesc;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		PerformanceMessage p = new PerformanceMessage();
		p.setAppid("1234");
		p.setKey("concurrency");
		p.setOperation("sayhello");
		p.setServerip("127.0.0.1");
		p.setValue("123");

		XStream xstream = new XStream();
		xstream.alias("performance", PerformanceMessage.class);

		String xml = xstream.toXML(p);

		System.out.println(xml.toString());

		xstream.alias("exception", ExceptionMessage.class);
		ExceptionMessage e = new ExceptionMessage();
		e.setAppid("1234");
		e.setOperation("sayhello");
		e.setServerip("127.0.0.1");
		// e.setParams("jack");
		e.setErrorcode(100080);
		e.setErrordesc("null point");

		String exml = xstream.toXML(e);

		System.out.println(exml.toString());

	}

}
