/**
 * 
 */
package com.meidusa.venus.monitor.impl;

import java.lang.reflect.Method;
import java.util.List;

import com.meidusa.venus.monitor.Monitor;
import com.meidusa.venus.monitor.event.Event;
import com.meidusa.venus.monitor.event.EventHandlerManager;
import com.meidusa.venus.monitor.event.MessageHandler;
import com.meidusa.venus.monitor.message.PerformanceMessage;
import com.meidusa.venus.monitor.model.MonitorContext;
import com.meidusa.venus.monitor.model.MonitorData;
import com.meidusa.venus.monitor.model.MonitorType;
import com.meidusa.venus.monitor.model.PerformanceMonitorData;
import com.thoughtworks.xstream.XStream;

/**
 * @author gaoyong
 * 
 */
public class PerformanceMonitor extends MonitorSkeleton implements Monitor{
	
	private PerformanceMonitorData monitorData = new PerformanceMonitorData();
			
	@Override
	public MonitorData getMonitorData() {
		return this.monitorData;
	}
	
	public void setMonitorData(PerformanceMonitorData monitorData) {
		this.monitorData = monitorData;
	}

	@Override
	public Object invoke(Object proxy, Method method, Object[] args)
			throws Throwable {
		Object result = null;
		monitorData.getConcurrentRequest().incrementAndGet();
		long startTime = System.currentTimeMillis();
		
		result = method.invoke(this.getTarget(), args);
		
		monitorData.setData(startTime);
		monitorData.getConcurrentRequest().decrementAndGet();
		
		return result;
	}

	@Override
	public void processEvent(Event event) {
		List<MessageHandler> handlers = EventHandlerManager.getHandlers(MonitorType.PERFORMANCE);
		MonitorContext context = event.getMonitorContext();
		//PerformanceMonitorData data = (PerformanceMonitorData) context.getMonitorData();
		XStream xstream = new XStream();
		xstream.alias("performance", PerformanceMessage.class);
		PerformanceMessage message = new PerformanceMessage();
		message.setAppid(context.getAppId());
		message.setServerip(context.getServerIp());
		message.setOperation(context.getMoniteeName());
		switch(event.getEventType()){
		  case Event.AVG:
			    message.setKey("avg");
			    message.setValue(String.valueOf(monitorData.getAverageInterval())); 
				break;
		  case Event.CONCURRENT:
			    message.setKey("concurrency");
			    message.setValue(String.valueOf(monitorData.getConcurrentRequest()));
				break;
		  default: 
			    break;
		}
		for(MessageHandler handler:handlers){
	    	handler.handleMessage(xstream.toXML(message));
	    }
		
	}

	


}
