/**
 * 
 */
package com.meidusa.venus.monitor.impl;

import java.lang.reflect.Proxy;

import com.meidusa.venus.monitor.Monitor;
import com.meidusa.venus.monitor.model.MonitorContext;

/**
 * @author gaoyong
 *
 */
public abstract class MonitorSkeleton implements Monitor{
	
	private Object target;
	private MonitorContext monitorContext;
	
	public Object getTarget() {
		return target;
	}
	public void setTarget(Object target) {
		this.target = target;
	}
	
	public MonitorContext getMonitorContext() {
		return monitorContext;
	}

	public void setMonitorContext(MonitorContext monitorContext) {
		this.monitorContext = monitorContext;
	}

	@Override
	public Object monitor(Object invokee) {
		this.setTarget(invokee);
		return Proxy.newProxyInstance(invokee.getClass().getClassLoader(), invokee
						.getClass().getInterfaces(), this);
	}
}
