/**
 * 
 */
package com.meidusa.venus.monitor.impl;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.VenusExceptionCodeConstant;
import com.meidusa.venus.monitor.Monitor;
import com.meidusa.venus.monitor.event.Event;
import com.meidusa.venus.monitor.event.EventHandlerManager;
import com.meidusa.venus.monitor.event.MessageHandler;
import com.meidusa.venus.monitor.message.ExceptionMessage;
import com.meidusa.venus.monitor.model.ExceptionInfo;
import com.meidusa.venus.monitor.model.ExceptionMonitorData;
import com.meidusa.venus.monitor.model.MonitorContext;
import com.meidusa.venus.monitor.model.MonitorType;
import com.thoughtworks.xstream.XStream;


/**
 * @author gaoyong
 *
 */
public class ExceptionMonitor extends MonitorSkeleton implements Monitor {
	
	private ExceptionMonitorData monitorData = new ExceptionMonitorData();

	public ExceptionMonitorData getMonitorData() {
		return monitorData;
	}

	public void setMonitorData(ExceptionMonitorData monitorData) {
		this.monitorData = monitorData;
	}

	@Override
	public Object invoke(Object proxy, Method method, Object[] args)
			throws Throwable {
		Object result = null;
		try {
			result = method.invoke(this.getTarget(), args);
		} catch (Exception exception) {
			ExceptionInfo info = new ExceptionInfo();
			if(exception instanceof CodedException){
				CodedException codedException = (CodedException) exception;
				info.setErrorDesc(codedException.getMessage());
				info.setErrorCode(codedException.getErrorCode());
			}
			else{
				info.setErrorDesc(exception.getCause().toString());
				info.setErrorCode(VenusExceptionCodeConstant.SERVICE_UNAVAILABLE_EXCEPTION);
				
			}
			monitorData.addException(info);
			throw exception;
		} 
		return result;
	}

	@Override
	public void processEvent(Event event) {
		List<MessageHandler> handlers = EventHandlerManager.getHandlers(MonitorType.EXCEPTION);
		MonitorContext context = event.getMonitorContext();

		Set<Entry<Integer,ExceptionInfo>> exceptions = monitorData.getExceptions().entrySet();
		Iterator<Entry<Integer,ExceptionInfo>> iterator = exceptions.iterator();
		while(iterator.hasNext()){
			
			XStream xstream = new XStream();
			xstream.alias("exception", ExceptionMessage.class);
			ExceptionMessage exceptionMessage = new ExceptionMessage();
			exceptionMessage.setAppid(context.getAppId());
			exceptionMessage.setOperation(context.getMoniteeName());
			exceptionMessage.setServerip(context.getServerIp());
			
			Map.Entry<Integer,ExceptionInfo> entry = iterator.next();
			ExceptionInfo info = entry.getValue();
			exceptionMessage.setErrorcode(info.getErrorCode());
			exceptionMessage.setErrordesc(info.getErrorDesc());
			
			for(MessageHandler handler:handlers){
				handler.handleMessage(xstream.toXML(exceptionMessage));
		    }
		}
		
	}
	
}
