/**
 * 
 */
package com.meidusa.venus.monitor.event;

import java.util.Enumeration;

import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.net.SyslogAppender;

/**
 * @author gaoyong
 * 
 */
public class LogEventHandler implements MessageHandler {

	private Logger log;

	public Logger getLog() {
		return log;
	}

	public void setLog(Logger log) {
		this.log = log;
	}

	public LogEventHandler(String categaoryName) {
		this.log = Logger.getLogger(categaoryName);

		this.log.setLevel(Level.INFO);
		this.log.setAdditivity(false);
		SyslogAppender appender = new SyslogAppender();

		// appender.setHeader(true);
		Layout layout = new PatternLayout();
		appender.setLayout(layout);
		appender.setSyslogHost("127.0.0.1");
		this.log.addAppender(appender);
	}
	
	public void configSyslog(String syslogHost,String pattern,String level){
		if(level!=null&&!level.trim().equals("")){
			log.setLevel(Level.toLevel(level));
		}
		if(syslogHost!=null&&!syslogHost.trim().equals("")){
			Enumeration<SyslogAppender> e = log.getAllAppenders();
			while(e.hasMoreElements()){
				SyslogAppender appender = (SyslogAppender) e.nextElement();
				appender.setSyslogHost(syslogHost);
			}
		}
		if(pattern!=null&&!pattern.trim().equals("")){
			Enumeration<SyslogAppender> e = log.getAllAppenders();
			while(e.hasMoreElements()){
				SyslogAppender appender = (SyslogAppender) e.nextElement();
				appender.setLayout(new PatternLayout(pattern));
			}
		}
	}


	@Override
	public void handleMessage(String msg) {
		sendLog(msg);
	}

	void sendLog(String msg) {
		log.log(log.getLevel(), msg);
	}
}
