/**
 * 
 */
package com.meidusa.venus.monitor.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.meidusa.venus.monitor.model.MonitorType;

/**
 * @author gaoyong
 *
 */
public class EventHandlerManager {
	private static Map<MonitorType,List<MessageHandler>> handlerMaps = new HashMap<MonitorType, List<MessageHandler>>();
	
	public static List<MessageHandler> getHandlers(MonitorType type){
		return handlerMaps.get(type);
	}
	
	public static void addHandlers(MonitorType type,MessageHandler handler){
		if(handlerMaps.containsKey(type)){
			handlerMaps.get(type).add(handler);
		}
		else{
			List<MessageHandler> handlers = new ArrayList<MessageHandler>();
			handlers.add(handler);
			handlerMaps.put(type,handlers);
		}
	}

}
