/**
 * 
 */
package com.meidusa.venus.monitor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.meidusa.venus.monitor.impl.MonitorFactory;
import com.meidusa.venus.monitor.model.MonitorKey;


/**
 * @author gaoyong
 *
 */
public class MonitorManager {

	private static Map<MonitorKey,Monitor> monitors = new ConcurrentHashMap<MonitorKey, Monitor>();
	
	MonitorFactory factory;
	
	public MonitorManager(MonitorFactory factory) {
		super();
		this.factory = factory;
	}

	public MonitorFactory getFactory() {
		return factory;
	}

	public void setFactory(MonitorFactory factory) {
		this.factory = factory;
	}

	public static Map<MonitorKey, Monitor> getMonitors() {
		return monitors;
	}

	public Monitor getMonitor(MonitorKey key){
		if(monitors.containsKey(key)){
			return monitors.get(key);
		}
		else{
			Monitor monitor = factory.createMonitor();
			addMonitor(key,monitor);
			return monitor;
		}
	}
	
    private void addMonitor(MonitorKey key,Monitor value){
		if(key == null && value == null)
			throw new NullPointerException();
		if(key.getInterfaceName()==null || key.getInterfaceName().trim().equals("")){
			throw new IllegalArgumentException();
		}
		if(key.getParamNums() < 0){
			throw new IllegalArgumentException();
		}
	    monitors.put(key, value);
	}
}
