/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet.serialize;

import com.meidusa.venus.io.packet.AbstractServiceRequestPacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.utils.GZipUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Map;

public class SerializeServiceRequestPacket
extends AbstractServiceRequestPacket {
    private static final long serialVersionUID = 1L;
    private Map<String, Type> typeMap;
    private Serializer serializer;
    public byte[] traceId;
    public byte[] rootId;
    public byte[] parentId;
    public byte[] messageId;

    public SerializeServiceRequestPacket(Serializer serializer, Map<String, Type> typeMap) {
        this.typeMap = typeMap;
        this.serializer = serializer;
    }

    @Override
    protected void readBody(ServicePacketBuffer buffer) {
        super.readBody(buffer);
        this.readParams(buffer);
        if (buffer.hasRemaining()) {
            this.traceId = new byte[16];
            buffer.readBytes(this.traceId, 0, 16);
        } else {
            this.traceId = PacketConstant.EMPTY_TRACE_ID;
        }
        if (buffer.hasRemaining()) {
            this.rootId = buffer.readLengthCodedBytes();
        }
        if (buffer.hasRemaining()) {
            this.parentId = buffer.readLengthCodedBytes();
        }
        if (buffer.hasRemaining()) {
            this.messageId = buffer.readLengthCodedBytes();
        }
    }

    @Override
    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        super.writeBody(buffer);
        this.wirteParams(buffer);
        if (this.traceId == null) {
            this.traceId = EMPTY_TRACE_ID;
        }
        buffer.writeBytes(this.traceId);
        buffer.writeLengthCodedBytes(this.rootId);
        buffer.writeLengthCodedBytes(this.parentId);
        buffer.writeLengthCodedBytes(this.messageId);
    }

    protected void wirteParams(ServicePacketBuffer buffer) {
        if (this.parameterMap != null) {
            byte[] bts = this.serializer.encode(this.parameterMap);
            if (bts != null) {
                if (PacketConstant.AUTO_COMPRESS_SIZE > 0 && bts.length > PacketConstant.AUTO_COMPRESS_SIZE) {
                    buffer.writeLengthCodedBytes(GZipUtil.compress(bts));
                    this.flags = (byte)(this.flags | 0x10);
                } else {
                    buffer.writeLengthCodedBytes(bts);
                }
            } else {
                buffer.writeInt(0);
            }
        } else {
            buffer.writeInt(0);
        }
    }

    protected void readParams(ServicePacketBuffer buffer) {
        if (buffer.hasRemaining()) {
            byte[] bts = buffer.readLengthCodedBytes();
            byte f = (byte)(this.flags & 0x10);
            if (bts != null & bts.length > 0) {
                if (f == 16) {
                    bts = GZipUtil.decompress(bts);
                }
                this.parameterMap = this.serializer.decode(bts, this.typeMap);
            }
        }
        if (this.parameterMap == null) {
            this.parameterMap = EMP_MAP;
        }
    }

    protected void readMessageId(ServicePacketBuffer buffer) {
    }
}

