/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.extension;

import com.meidusa.fastbson.FastBsonSerializer;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.SerializeConfig;
import com.meidusa.toolkit.common.bean.PureJavaReflectionProvider;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ExtensionResolver {
    protected static final Logger logger = LoggerFactory.getLogger(ExtensionResolver.class);
    private static ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public static void doScanExtension() {
        try {
            Resource[] resources;
            String packageSearchPath = "classpath*:/META-INF/venus.io.extension.ini";
            Resource[] resourceArray = resources = resourcePatternResolver.getResources(packageSearchPath);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray[n2];
                if (logger.isInfoEnabled()) {
                    logger.info("Scanning " + resource);
                }
                if (resource.isReadable()) {
                    try {
                        Profile.Section encoder;
                        Profile.Section decoder;
                        Ini ini = new Ini();
                        ini.load(resource.getInputStream());
                        Profile.Section section = (Profile.Section)ini.get((Object)"bson");
                        if (section != null) {
                            ExtensionResolver.register(section, 1);
                        }
                        if ((decoder = (Profile.Section)ini.get((Object)"json.decoder")) != null) {
                            ExtensionResolver.register(decoder, 2);
                        }
                        if ((encoder = (Profile.Section)ini.get((Object)"json.encoder")) != null) {
                            ExtensionResolver.register(encoder, 3);
                        }
                    }
                    catch (Throwable ex) {
                        logger.error("register extension error", ex);
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info("Ignored because not readable: " + resource);
                }
                ++n2;
            }
        }
        catch (IOException ex) {
            logger.error("register extension error", (Throwable)ex);
        }
    }

    private static void register(Profile.Section section, int type) {
        Set sets = section.entrySet();
        for (Map.Entry entry : sets) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String itype = null;
            if (StringUtils.isEmpty((String)value) || StringUtils.isEmpty((String)key)) continue;
            try {
                Class<?> bean = Class.forName(value.trim());
                Object object = PureJavaReflectionProvider.getInstance().newInstance(bean);
                Class<?> clazz = Class.forName(key);
                if (type == 1) {
                    itype = "bson";
                    FastBsonSerializer.registerSerializer(clazz, (com.meidusa.fastbson.serializer.ObjectSerializer)((com.meidusa.fastbson.serializer.ObjectSerializer)object));
                } else if (type == 2) {
                    itype = "json Deserializer";
                    ParserConfig.getGlobalInstance().putDeserializer(clazz, (ObjectDeserializer)object);
                } else if (type == 3) {
                    itype = "json Serializer";
                    SerializeConfig.getGlobalInstance().put(clazz, (ObjectSerializer)object);
                }
                logger.info("register type=" + itype + ", key=" + key + ", class=" + value);
            }
            catch (ClassNotFoundException e) {
                logger.error("register error,key=" + key + ",value=" + value, (Throwable)e);
            }
        }
    }
}

