/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.pool;

import com.meidusa.toolkit.common.poolable.MultipleLoadBalanceObjectPool;
import com.meidusa.toolkit.common.poolable.ObjectPool;
import com.meidusa.toolkit.common.poolable.PoolableObjectPool;
import com.meidusa.toolkit.util.StringUtil;
import com.meidusa.venus.io.authenticate.Authenticator;
import com.meidusa.venus.io.network.VenusBIOConnection;
import com.meidusa.venus.io.network.VenusBIOConnectionFactory;
import org.apache.commons.pool.PoolableObjectFactory;

public class VenusBIOPoolUtil {
    public static ObjectPool createObjectPool(String ipAddress, Authenticator authenticator) {
        if (!StringUtil.isEmpty((String)ipAddress)) {
            String[] ipList = StringUtil.split((String)ipAddress, (String)", ");
            PoolableObjectPool[] bioPools = new PoolableObjectPool[ipList.length];
            int i = 0;
            while (i < ipList.length) {
                VenusBIOConnectionFactory bioFactory = new VenusBIOConnectionFactory();
                if (authenticator != null) {
                    bioFactory.setAuthenticator(authenticator);
                }
                bioPools[i] = new PoolableObjectPool();
                bioPools[i].setTestOnBorrow(true);
                bioPools[i].setTestWhileIdle(true);
                bioFactory.setNeedPing(true);
                String[] temp = StringUtil.split((String)ipList[i], (String)":");
                if (temp.length > 1) {
                    bioFactory.setHost(temp[0]);
                    bioFactory.setPort(Integer.valueOf(temp[1]));
                } else {
                    bioFactory.setHost(temp[0]);
                    bioFactory.setPort(16800);
                }
                bioPools[i].setName("B-" + bioFactory.getHost() + ":" + bioFactory.getPort());
                bioPools[i].setFactory((PoolableObjectFactory)bioFactory);
                bioPools[i].init();
                ++i;
            }
            if (ipList.length > 1) {
                MultipleLoadBalanceObjectPool bioPool = new MultipleLoadBalanceObjectPool(1, (ObjectPool[])bioPools);
                bioPool.setName("B-V-" + ipAddress);
                bioPool.init();
                return bioPool;
            }
            return bioPools[0];
        }
        throw new IllegalArgumentException("ipaddress cannot be null");
    }

    public static void main(String[] args) {
        block12: {
            ObjectPool pool = VenusBIOPoolUtil.createObjectPool("127.0.0.1", null);
            VenusBIOConnection conn = null;
            try {
                try {
                    conn = (VenusBIOConnection)pool.borrowObject();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (conn == null) break block12;
                    try {
                        pool.returnObject((Object)conn);
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (conn != null) {
                    try {
                        pool.returnObject((Object)conn);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

