/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet;

import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import java.io.UnsupportedEncodingException;

public abstract class AuthenPacket
extends AbstractServicePacket {
    private static final long serialVersionUID = 1L;
    public byte authType;
    public int capabilities = 16;
    public byte shakeSerializeType;
    public String client = "VENUS-JAVA-CLIENT";
    public String version = "3.1.0-RELEASE";
    public String username;

    public AuthenPacket() {
        this.type = 0x3100000;
    }

    @Override
    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        super.writeBody(buffer);
        buffer.writeByte(this.authType);
        buffer.writeInt(this.capabilities);
        buffer.writeByte(this.shakeSerializeType);
        buffer.writeLengthCodedString(this.client, PACKET_CHARSET);
        buffer.writeLengthCodedString(this.version, PACKET_CHARSET);
        buffer.writeLengthCodedString(this.username, PACKET_CHARSET);
    }

    @Override
    protected void readBody(ServicePacketBuffer buffer) {
        super.readBody(buffer);
        this.authType = buffer.readByte();
        this.capabilities = buffer.readInt();
        this.shakeSerializeType = buffer.readByte();
        this.client = buffer.readLengthCodedString(PACKET_CHARSET);
        this.version = buffer.readLengthCodedString(PACKET_CHARSET);
        this.username = buffer.readLengthCodedString(PACKET_CHARSET);
    }

    public static byte getAuthenType(byte[] message) {
        return message[24];
    }
}

