/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.network;

import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;

public abstract class AbstractBIOConnection {
    protected long _lastEvent;
    private Socket socket;
    protected boolean closePosted = false;
    protected long lastMessageSent = System.currentTimeMillis();
    private String remoteAddress;
    private static int DEFAULT_BUFFER_SIZE = 4096;
    public static int MAX_BUFFER_SIZE = Integer.getInteger("tookit.packet.max", 0x200000);
    private byte[] tmp = new byte[4096];
    protected ByteBuffer _buffer = ByteBuffer.allocate(DEFAULT_BUFFER_SIZE);

    public AbstractBIOConnection(Socket socket, long createStamp) {
        this._lastEvent = createStamp;
        this.socket = socket;
        try {
            this.remoteAddress = this.socket.getRemoteSocketAddress().toString();
        }
        catch (Exception e) {
            this.remoteAddress = "socket not connected!";
        }
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setSoTimeout(int soTimeout) throws SocketException {
        this.socket.setSoTimeout(soTimeout);
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public void write(byte[] bts) throws IOException {
        try {
            this.socket.getOutputStream().write(bts);
        }
        catch (IOException e) {
            this.socket.close();
            throw e;
        }
    }

    public int getHeaderSize() {
        return 4;
    }

    protected int getPacketLength(ByteBuffer buffer, int offset) {
        if (buffer.position() < offset + this.getHeaderSize()) {
            return -1;
        }
        int length = buffer.get(offset) & 0xFF000000;
        length |= (buffer.get(++offset) & 0xFF) << 16;
        length |= (buffer.get(++offset) & 0xFF) << 8;
        return length |= (buffer.get(++offset) & 0xFF) << 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read() throws IOException {
        int _length = -1;
        do {
            int got;
            if ((got = this.socket.getInputStream().read(this.tmp)) <= 0) {
                throw new EOFException();
            }
            this.expandCapacity(got);
            this._buffer.put(this.tmp, 0, got);
            if (_length != -1 || got < this.getHeaderSize()) continue;
            _length = this.getPacketLength(this._buffer, 0);
            if (_length < -1 || _length > MAX_BUFFER_SIZE) {
                throw new IOException("over max packet limit,current=" + _length + " , limit=" + MAX_BUFFER_SIZE + ",improved limit via set System property (-Dtookit.packet.max= newlimit)");
            }
            if (_length < 0 || _length >= this.getHeaderSize()) continue;
            throw new IOException("packet error,decode full packet size=" + _length + ", but packet head need size=" + this.getHeaderSize());
        } while (_length < 0 || this._buffer.position() < _length);
        this._buffer.flip();
        byte[] bts = new byte[_length];
        this._buffer.get(bts);
        this._buffer.clear();
        byte[] byArray = bts;
        return byArray;
    }

    private void expandCapacity(int needSize) {
        if (this._buffer.remaining() < needSize) {
            int newSize = this._buffer.capacity() << 1;
            ByteBuffer newbuf = ByteBuffer.allocate(Math.max(newSize, needSize + this._buffer.position()));
            newbuf.put((ByteBuffer)this._buffer.flip());
            this._buffer = newbuf;
        }
    }

    public void close() throws Exception {
        this.socket.close();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }
}

