/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.network;

import com.meidusa.toolkit.net.AuthingableFrontendConnection;
import com.meidusa.venus.io.packet.OKPacket;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VenusFrontendConnection
extends AuthingableFrontendConnection {
    private static Logger logger = LoggerFactory.getLogger(VenusFrontendConnection.class);
    private static final SequenceGenerator SEQUENCE_GENERATOR = new SequenceGenerator();
    public static OKPacket OK = new OKPacket();
    private byte serializeType = 1;
    private int clientId;
    private long sequenceID = SequenceGenerator.access$1(SEQUENCE_GENERATOR);

    public VenusFrontendConnection(SocketChannel channel) {
        super(channel);
    }

    public short getProtocol() {
        return this.getSerializeType();
    }

    public int getClientId() {
        return this.clientId;
    }

    public byte getSerializeType() {
        return this.serializeType;
    }

    public long getSequenceID() {
        return this.sequenceID;
    }

    public boolean isIdleTimeout() {
        if (this.isAuthenticated) {
            return false;
        }
        return super.isIdleTimeout();
    }

    public void handleError(int errCode, Throwable t) {
        if (t instanceof EOFException) {
            if (logger.isDebugEnabled()) {
                logger.debug(this.toString(), t);
            }
        } else if (this.isConnectionReset(t)) {
            if (logger.isInfoEnabled()) {
                logger.info(this.toString(), t);
            }
        } else {
            logger.warn(this.toString(), t);
        }
        this.close();
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public void setSerializeType(byte serializeType) {
        this.serializeType = serializeType;
    }

    protected int getPacketLength(ByteBuffer buffer, int offset) {
        if (buffer.position() < offset + 4) {
            return -1;
        }
        int length = buffer.get(offset) & 0xFF000000;
        length |= (buffer.get(++offset) & 0xFF) << 16;
        length |= (buffer.get(++offset) & 0xFF) << 8;
        return length |= (buffer.get(++offset) & 0xFF) << 0;
    }

    private static class SequenceGenerator {
        private static final long MAX_VALUE = Long.MAX_VALUE;
        private long id = 0L;
        private final Object lock = new Object();

        private SequenceGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long nextId() {
            Object object = this.lock;
            synchronized (object) {
                if (this.id >= Long.MAX_VALUE) {
                    this.id = 0L;
                }
                return ++this.id;
            }
        }

        static /* synthetic */ long access$1(SequenceGenerator sequenceGenerator) {
            return sequenceGenerator.nextId();
        }
    }
}

