/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet;

import com.meidusa.venus.io.packet.DummyAuthenPacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.utils.StringUtil;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang.StringUtils;

public class PasswordAuthenPacket
extends DummyAuthenPacket {
    private static final long serialVersionUID = 1L;
    public transient String password;
    public transient String challenge;
    public byte[] encryptedPasswd;

    public PasswordAuthenPacket() {
        this.authType = (byte)2;
    }

    @Override
    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        super.writeBody(buffer);
        this.encryptedPasswd = PasswordAuthenPacket.encryptPasswd(this.password, this.challenge);
        buffer.writeLengthCodedString(this.username, PACKET_CHARSET);
        buffer.writeLengthCodedBytes(this.encryptedPasswd);
    }

    @Override
    protected void readBody(ServicePacketBuffer buffer) {
        super.readBody(buffer);
        this.username = buffer.readLengthCodedString(PACKET_CHARSET);
        this.encryptedPasswd = buffer.readLengthCodedBytes();
    }

    public static byte[] encryptPasswd(String password, String challenge) {
        if (!StringUtils.isEmpty((String)challenge) && !StringUtils.isEmpty((String)password)) {
            try {
                String passwdMd5 = StringUtil.md5(password);
                return StringUtil.scramble411(passwdMd5, challenge);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }
}

