/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet;

import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import java.io.UnsupportedEncodingException;

public class ErrorPacket
extends AbstractServicePacket {
    private static final long serialVersionUID = 1L;
    public int errorCode;
    public String message;
    public byte[] additionalData;

    public ErrorPacket() {
        this.type = -1;
    }

    @Override
    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        super.writeBody(buffer);
        buffer.writeInt(this.errorCode);
        buffer.writeLengthCodedString(this.message, PACKET_CHARSET);
        if (this.additionalData != null) {
            buffer.writeLengthCodedBytes(this.additionalData);
        }
    }

    @Override
    protected void readBody(ServicePacketBuffer buffer) {
        super.readBody(buffer);
        this.errorCode = buffer.readInt();
        this.message = buffer.readLengthCodedString(PACKET_CHARSET);
        if (buffer.hasRemaining()) {
            this.additionalData = buffer.readLengthCodedBytes();
        }
    }

    public String toString() {
        return "E" + this.errorCode + ": " + this.message;
    }
}

