/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet;

import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import java.io.UnsupportedEncodingException;

public abstract class ServiceNofityPacket
extends AbstractServicePacket {
    private static final long serialVersionUID = 1L;
    public byte[] identityData;
    public int errorCode;
    public String errorMessage;
    public Object callbackObject;
    public byte[] additionalData;
    public byte[] traceId;
    public String apiName;

    public ServiceNofityPacket() {
        this.type = 0x4000001;
    }

    @Override
    protected void readBody(ServicePacketBuffer buffer) {
        super.readBody(buffer);
        this.identityData = buffer.readLengthCodedBytes();
        this.errorCode = buffer.readInt();
        if (this.errorCode != 0) {
            this.errorMessage = buffer.readLengthCodedString(PACKET_CHARSET);
        } else {
            this.callbackObject = this.readCallBackObject(buffer);
        }
        if (buffer.hasRemaining()) {
            this.additionalData = buffer.readLengthCodedBytes();
        }
        if (buffer.hasRemaining()) {
            this.traceId = new byte[16];
            buffer.readBytes(this.traceId, 0, 16);
        }
        if (buffer.hasRemaining()) {
            this.apiName = buffer.readLengthCodedString(PACKET_CHARSET);
        }
    }

    protected abstract Object readCallBackObject(ServicePacketBuffer var1);

    protected abstract void writeCallBackObject(ServicePacketBuffer var1, Object var2);

    @Override
    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        super.writeBody(buffer);
        buffer.writeLengthCodedBytes(this.identityData);
        buffer.writeInt(this.errorCode);
        if (this.errorCode != 0) {
            buffer.writeLengthCodedString(this.errorMessage, PACKET_CHARSET);
        } else {
            this.writeCallBackObject(buffer, this.callbackObject);
        }
        buffer.writeLengthCodedBytes(this.additionalData);
        if (this.traceId == null) {
            this.traceId = EMPTY_TRACE_ID;
        }
        buffer.writeBytes(this.traceId);
        buffer.writeLengthCodedString(this.apiName, PACKET_CHARSET);
    }
}

