/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.network;

import com.meidusa.toolkit.net.util.AuthenticationException;
import com.meidusa.venus.io.authenticate.Authenticator;
import com.meidusa.venus.io.authenticate.DummyAuthenticator;
import com.meidusa.venus.io.network.VenusBIOConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.AuthenPacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.HandshakePacket;
import com.meidusa.venus.io.packet.PingPacket;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.pool.PoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VenusBIOConnectionFactory
implements PoolableObjectFactory<VenusBIOConnection> {
    private static Logger authenticatorLogger = LoggerFactory.getLogger(Authenticator.class);
    private static Logger logger = LoggerFactory.getLogger(VenusBIOConnectionFactory.class);
    protected static PingPacket PING_PACKET = new PingPacket();
    private int sendBufferSize = 64;
    private int receiveBufferSize = 64;
    private boolean tcpNoDelay = true;
    private boolean keepAlive = true;
    private int coTimeout = 5000;
    private String host;
    private int port = 16800;
    private int soTimeout = 30000;
    private boolean needPing = false;
    private long maxLiveTime = 0L;
    private Authenticator<HandshakePacket, AuthenPacket> authenticator = new DummyAuthenticator<AuthenPacket>();

    public int getCoTimeout() {
        return this.coTimeout;
    }

    public void setCoTimeout(int coTimeout) {
        this.coTimeout = coTimeout;
    }

    public boolean isNeedPing() {
        return this.needPing;
    }

    public void setNeedPing(boolean needPing) {
        this.needPing = needPing;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String ipAddress) {
        this.host = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void activateObject(VenusBIOConnection arg0) throws Exception {
    }

    public Authenticator<HandshakePacket, AuthenPacket> getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator<HandshakePacket, AuthenPacket> authenticator) {
        this.authenticator = authenticator;
    }

    public long getMaxLiveTime() {
        return this.maxLiveTime;
    }

    public void setMaxLiveTime(long maxLiveTime) {
        this.maxLiveTime = maxLiveTime;
    }

    public void destroyObject(VenusBIOConnection arg0) throws Exception {
        VenusBIOConnection conn = arg0;
        conn.close();
        if (logger.isDebugEnabled()) {
            logger.debug("conn id=" + conn + " destory");
        }
    }

    public VenusBIOConnection makeObject() throws Exception {
        Socket socket = new Socket();
        InetSocketAddress address = null;
        address = this.host == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.host, this.port);
        socket.setSendBufferSize(this.sendBufferSize * 1024);
        socket.setReceiveBufferSize(this.receiveBufferSize * 1024);
        socket.setTcpNoDelay(this.tcpNoDelay);
        socket.setKeepAlive(this.keepAlive);
        try {
            if (this.soTimeout > 0) {
                socket.setSoTimeout(this.soTimeout);
            }
            if (this.coTimeout > 0) {
                socket.connect(address, this.coTimeout);
            } else {
                socket.connect(address);
            }
        }
        catch (ConnectException e) {
            throw new ConnectException(e.getMessage() + " " + address.getHostName() + ":" + address.getPort());
        }
        VenusBIOConnection conn = new VenusBIOConnection(socket, System.currentTimeMillis());
        byte[] bts = conn.read();
        HandshakePacket handshakePacket = new HandshakePacket();
        handshakePacket.init(bts);
        AuthenPacket authen = this.getAuthenticator().createAuthenPacket(handshakePacket);
        conn.write(authen.toByteArray());
        bts = conn.read();
        int type = AbstractServicePacket.getType(bts);
        if (type == 1) {
            if (authenticatorLogger.isInfoEnabled()) {
                authenticatorLogger.info("authenticated by server=" + this.host + ":" + this.port + " success");
            }
        } else if (type == -1) {
            ErrorPacket error = new ErrorPacket();
            error.init(bts);
            if (authenticatorLogger.isInfoEnabled()) {
                authenticatorLogger.info("authenticated by server=" + this.host + ":" + this.port + " error={code=" + error.errorCode + ",message=" + error.message + "}");
            }
            throw new AuthenticationException(error.message, error.errorCode);
        }
        return conn;
    }

    public void passivateObject(VenusBIOConnection arg0) throws Exception {
    }

    public boolean validateObject(VenusBIOConnection arg0) {
        long eliminateTime;
        VenusBIOConnection conn = arg0;
        if (conn.isClosed()) {
            return false;
        }
        if (this.needPing) {
            try {
                conn.write(PING_PACKET.toByteArray());
                conn.read();
            }
            catch (IOException e) {
                return false;
            }
        }
        return this.maxLiveTime == 0L || (eliminateTime = conn.createTimestamp + this.maxLiveTime) <= System.currentTimeMillis();
    }
}

