/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.serializer;

import com.meidusa.venus.io.extension.ExtensionResolver;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.bson.FastBsonSerializerWrapper;
import com.meidusa.venus.io.serializer.java.JavaSerializer;
import com.meidusa.venus.io.serializer.json.JsonSerializer;

public class SerializerFactory {
    private static JsonSerializer json;
    private static FastBsonSerializerWrapper bson;
    private static JavaSerializer java;

    static {
        ExtensionResolver.doScanExtension();
        json = new JsonSerializer();
        bson = new FastBsonSerializerWrapper();
        java = new JavaSerializer();
    }

    public static Serializer getSerializer(short type) {
        switch (type) {
            case 0: {
                return json;
            }
            case 1: {
                return bson;
            }
            case 2: {
                return java;
            }
        }
        return json;
    }
}

