/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.network;

import com.meidusa.toolkit.net.AuthingableBackendConnection;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.venus.io.Status;
import com.meidusa.venus.io.authenticate.Authenticator;
import com.meidusa.venus.io.authenticate.DummyAuthenticator;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.AuthenPacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.HandshakePacket;
import com.meidusa.venus.io.packet.PingPacket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VenusBackendConnection
extends AuthingableBackendConnection
implements MessageHandler {
    private static Logger logger = LoggerFactory.getLogger(VenusBackendConnection.class);
    private Authenticator<HandshakePacket, AuthenPacket> authenticator = new DummyAuthenticator<AuthenPacket>();
    private Status status = Status.WAITE_HANDSHAKE;
    private byte serializeType;
    private boolean active;

    public VenusBackendConnection(SocketChannel channel) {
        super(channel);
        this.setHandler(this);
    }

    public byte getSerializeType() {
        return this.serializeType;
    }

    public void ping(long now) {
        this.write(new PingPacket().toByteBuffer());
        if (logger.isDebugEnabled()) {
            logger.debug("send ping packet to " + this.getId());
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean isactive) {
        this.active = isactive;
    }

    public void handle(Connection conn, byte[] message) {
        if (AbstractServicePacket.getType(message) == -1) {
            this.setAuthenticated(false);
            ErrorPacket error = new ErrorPacket();
            error.init(message);
            logger.error("handShake with host=" + this.getId() + ", errorCode=" + error.errorCode + " ,message=" + error.message + ",hashCode=" + ((Object)((Object)this)).hashCode());
            return;
        }
        if (this.status == Status.WAITE_HANDSHAKE) {
            if (logger.isDebugEnabled()) {
                logger.debug("1. handShake with " + this.getId() + ",hashCode=" + ((Object)((Object)this)).hashCode());
            }
            HandshakePacket handpacket = new HandshakePacket();
            handpacket.init(message);
            AuthenPacket authen = this.getAuthenticator().createAuthenPacket(handpacket);
            this.serializeType = authen.shakeSerializeType;
            authen.capabilities |= 0x80;
            this.status = Status.AUTHING;
            if (logger.isDebugEnabled()) {
                logger.debug("2. authing packet sent to server:" + this.getId() + ",hashCode=" + ((Object)((Object)this)).hashCode());
            }
            this.write(authen.toByteBuffer());
        } else if (this.status == Status.AUTHING) {
            if (AbstractServicePacket.getType(message) == 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("3. authing success from server:" + this.getId() + ",hashCode=" + ((Object)((Object)this)).hashCode());
                }
                this.setAuthenticated(true);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("3. authing fail from server:" + this.getId() + ",hashCode=" + ((Object)((Object)this)).hashCode());
            }
            this.setAuthenticated(false);
            return;
        }
    }

    public Authenticator<HandshakePacket, AuthenPacket> getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator<HandshakePacket, AuthenPacket> authenticator) {
        this.authenticator = authenticator;
    }

    public boolean checkValid() {
        return !this.isClosed() && this.isAuthenticated();
    }

    public void handleError(int errCode, Throwable t) {
        logger.error("handle error=" + errCode + ", host=" + this.getHost() + ":" + this.port + ",hash=" + ((Object)((Object)this)).hashCode(), t);
        this.close();
    }

    protected int getPacketLength(ByteBuffer buffer, int offset) {
        if (buffer.position() < offset + 4) {
            return -1;
        }
        int length = buffer.get(offset) & 0xFF000000;
        length |= (buffer.get(++offset) & 0xFF) << 16;
        length |= (buffer.get(++offset) & 0xFF) << 8;
        return length |= (buffer.get(++offset) & 0xFF) << 0;
    }
}

