/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.network;

import com.meidusa.toolkit.common.poolable.ObjectPool;
import com.meidusa.toolkit.common.poolable.PoolableObject;
import com.meidusa.venus.io.VenusPacketMetaData;
import com.meidusa.venus.io.network.AbstractBIOConnection;
import com.meidusa.venus.io.packet.PingPacket;
import com.meidusa.venus.io.packet.VenusStatusRequestPacket;
import com.meidusa.venus.io.packet.VenusStatusResponsePacket;
import java.io.IOException;
import java.net.Socket;

public class VenusBIOConnection
extends AbstractBIOConnection
implements PoolableObject {
    private static VenusPacketMetaData PACKET_META_DATA = new VenusPacketMetaData();
    private static PingPacket PING_PACKET = new PingPacket();
    private static VenusStatusRequestPacket STATUS = new VenusStatusRequestPacket();
    private ObjectPool objectPool = null;
    private boolean active = false;
    public long createTimestamp;

    public VenusBIOConnection(Socket socket, long createStamp) {
        super(socket, createStamp);
        this.createTimestamp = createStamp;
    }

    public ObjectPool getObjectPool() {
        return this.objectPool;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isRemovedFromPool() {
        return this.objectPool == null;
    }

    public void setActive(boolean isactive) {
        this.active = isactive;
    }

    public void setObjectPool(ObjectPool pool) {
        this.objectPool = pool;
    }

    public boolean checkValid() {
        try {
            this.write(STATUS.toByteArray());
            VenusStatusResponsePacket packet = new VenusStatusResponsePacket();
            packet.init(this.read());
            if (packet.status == 2) {
                ObjectPool pool = this.getObjectPool();
                if (pool != null) {
                    pool.setValid(false);
                }
                return false;
            }
            return true;
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }
}

