/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet;

import com.meidusa.venus.io.packet.AbstractVenusPacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;

public class VenusRouterPacket
extends AbstractVenusPacket {
    public static final int CONNECTION_SEQUENCE_ID = 14;
    public static final int FRONTEND_REQUEST_ID = 22;
    public static final int BACKEND_REQUEST_ID = 30;
    public static final int VENUS_ROUTER_PACKET_DATA_POSITION = 39;
    private static final long serialVersionUID = 1L;
    public transient byte[] original;
    public int srcIP;
    public long connectionID;
    public long frontendRequestID;
    public long backendRequestID;
    public byte serializeType = (byte)-1;
    public byte[] data;

    public VenusRouterPacket() {
        this.type = 0x8000001;
    }

    protected void readBody(ServicePacketBuffer buffer) {
        this.srcIP = buffer.readInt();
        this.connectionID = buffer.readLong();
        this.frontendRequestID = buffer.readLong();
        this.backendRequestID = buffer.readLong();
        this.serializeType = buffer.readByte();
        this.data = buffer.readRemaining();
        buffer.setPosition(buffer.getPosition() + this.data.length);
    }

    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        buffer.writeInt(this.srcIP);
        buffer.writeLong(this.connectionID);
        buffer.writeLong(this.frontendRequestID);
        buffer.writeLong(this.backendRequestID);
        buffer.writeByte(this.serializeType);
        buffer.writeBytes(this.data);
    }

    protected int calculatePacketSize() {
        return 42;
    }

    protected Class<ServicePacketBuffer> getPacketBufferClass() {
        return ServicePacketBuffer.class;
    }

    public static long getConnectionSequenceID(byte[] buf) {
        return ServicePacketBuffer.BUFFER.getByteOrder() == ByteOrder.BIG_ENDIAN ? VenusRouterPacket.getLongB(buf, 14) : VenusRouterPacket.getLongL(buf, 14);
    }

    public static long getSourceRequestID(byte[] buf) {
        return ServicePacketBuffer.BUFFER.getByteOrder() == ByteOrder.BIG_ENDIAN ? VenusRouterPacket.getLongB(buf, 22) : VenusRouterPacket.getLongL(buf, 22);
    }

    public static long getRemoteRequestID(byte[] buf) {
        return ServicePacketBuffer.BUFFER.getByteOrder() == ByteOrder.BIG_ENDIAN ? VenusRouterPacket.getLongB(buf, 30) : VenusRouterPacket.getLongL(buf, 30);
    }

    public static byte[] getData(byte[] message) {
        byte[] bts = new byte[message.length - 39];
        System.arraycopy(message, 39, bts, 0, bts.length);
        return bts;
    }
}

