package com.meidusa.venus.io.packet;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;

public class VenusRouterPacket  extends AbstractVenusPacket{
	/**
     * connection Sequence id in router packet
     */
    public static final int CONNECTION_SEQUENCE_ID = VENUS_HEADER_LENGTH + 4;
    
    /**
     * connection Sequence id in router packet
     */
    public static final int FRONTEND_REQUEST_ID = CONNECTION_SEQUENCE_ID+8;
    
    /**
     * connection Sequence id in router packet
     */
    public static final int BACKEND_REQUEST_ID = FRONTEND_REQUEST_ID+8;
    
    public static final int VENUS_ROUTER_PACKET_DATA_POSITION = BACKEND_REQUEST_ID+8+1;
    
	private static final long serialVersionUID = 1L;
	
	/**
	 * ݰԭʼݣֶβݴ䣬ֻǽöݴ
	 */
	public transient byte[] original;
	
	/**
	 * ͻ˵ԭʼIP
	 * @see InetAddressUtil#pack(byte[])
	 */
	public int srcIP;
	
	/**
	 * ͻ˵HSBеIDʶ
	 */
	public long connectionID;
	
	/**
	 * Frontend connection RequestID in hsb
	 */
	public long frontendRequestID;
	
	/**
	 * Backend connection RequestID in hsb
	 */
	public long backendRequestID;
	
	/**
	 * ڿͻ˾hsbݰòõлʽ
	 * ˽յVenusRouterPacket͵ݰлʽԸֶΪ׼
	 * ݰ connectionеserializeTypeΪ׼
	 */
	public byte serializeType = -1;
	
	/**
	 * ·ݰУֶδͻݰݣһ߼ݰ
	 */
	public byte[] data;
	
	public VenusRouterPacket(){
		this.type = PACKET_TYPE_ROUTER;
	}
	
	@Override
	protected void readBody(ServicePacketBuffer buffer) {
		srcIP = buffer.readInt();
		connectionID = buffer.readLong();
		frontendRequestID = buffer.readLong();
		backendRequestID = buffer.readLong();
		serializeType = buffer.readByte();
		data = buffer.readRemaining();
		buffer.setPosition(buffer.getPosition()+data.length);
	}

	@Override
	protected void writeBody(ServicePacketBuffer buffer)
			throws UnsupportedEncodingException {
		buffer.writeInt(srcIP);
		buffer.writeLong(connectionID);
		buffer.writeLong(frontendRequestID);
		buffer.writeLong(backendRequestID);
		buffer.writeByte(serializeType);
		buffer.writeBytes(data);
		
	}

	@Override
	protected int calculatePacketSize() {
		return 42;
	}

	@Override
	 protected Class<ServicePacketBuffer> getPacketBufferClass() {
        return ServicePacketBuffer.class;
    }
	
    public static long getConnectionSequenceID(byte[] buf) {
        return ServicePacketBuffer.BUFFER.getByteOrder() == ByteOrder.BIG_ENDIAN ? getLongB(buf,CONNECTION_SEQUENCE_ID):getLongL(buf,CONNECTION_SEQUENCE_ID);
    }
    
    public static long getSourceRequestID(byte[] buf) {
        return ServicePacketBuffer.BUFFER.getByteOrder() == ByteOrder.BIG_ENDIAN ? getLongB(buf,FRONTEND_REQUEST_ID):getLongL(buf,FRONTEND_REQUEST_ID);
    }
    
    public static long getRemoteRequestID(byte[] buf) {
        return ServicePacketBuffer.BUFFER.getByteOrder() == ByteOrder.BIG_ENDIAN ? getLongB(buf,BACKEND_REQUEST_ID):getLongL(buf,BACKEND_REQUEST_ID);
    }
    
    public static byte[] getData(byte[] message) {
    	byte[] bts = new byte[message.length - VENUS_ROUTER_PACKET_DATA_POSITION];
		System.arraycopy(message, VENUS_ROUTER_PACKET_DATA_POSITION, bts, 0, bts.length);
		return bts;
    }
}
