package com.meidusa.venus.io.packet;

import java.nio.ByteOrder;

import com.meidusa.toolkit.net.packet.AbstractPacket;

public abstract class AbstractVenusPacket extends AbstractPacket<ServicePacketBuffer> implements PacketConstant{
    private static final long serialVersionUID = 1L;
    public final static int VENUS_HEADER_LENGTH = 10;
    /**
     * ߼ȣͷ
     */
    protected int packetLength;//4
    
    public short protocolVersion = PROTOCOL_VERSION;//2
    
    /**
     * ݰ,
     */
    public int type;//4
    
    protected void writeHead(ServicePacketBuffer buffer) {
        buffer.setPosition(0);
        buffer.writeInt(0);
        buffer.writeShort(protocolVersion);
        buffer.writeInt(type);
    }

    @Override
    protected void initHead(ServicePacketBuffer buffer) {
        packetLength = buffer.readInt();
        protocolVersion = buffer.readShort();
        type = buffer.readInt();
    }

    @Override
    protected void afterPacketWritten(ServicePacketBuffer buffer) {
        int position = buffer.getPosition();
        packetLength = position;
        buffer.setPosition(0);
        buffer.writeInt(packetLength);
        buffer.setPosition(position);
    }
    
    static private int makeInt(byte b3, byte b2, byte b1, byte b0) {
    	return (int)((((b3 & 0xff) << 24) |
    		      ((b2 & 0xff) << 16) |
    		      ((b1 & 0xff) <<  8) |
    		      ((b0 & 0xff) <<  0)));
    }
    
    
    
    static int getIntL(byte[] buf, int bi) {
    	return makeInt(buf[bi + 3],
    			buf[bi + 2],
    			buf[bi + 1],
    			buf[bi + 0]);
    }
    static int getIntB(byte[] buf, int bi) {
    	return makeInt(buf[bi + 0],
    			buf[bi + 1],
    			buf[bi + 2],
    			buf[bi + 3]);
    }
    
    static private long makeLong(byte b7,byte b6,byte b5,byte b4,byte b3, byte b2, byte b1, byte b0) {
    	return (long)((
    			((b7 & 0xff) << 24) |
    			((b6 & 0xff) << 24) |
    			((b5 & 0xff) << 24) |
    			((b4 & 0xff) << 24) |
    			((b3 & 0xff) << 24) |
    		      ((b2 & 0xff) << 16) |
    		      ((b1 & 0xff) <<  8) |
    		      ((b0 & 0xff) <<  0)));
    }
    
    static long getLongL(byte[] buf, int bi) {
    	return makeLong(
    			buf[bi + 7],
    			buf[bi + 6],
    			buf[bi + 5],
    			buf[bi + 4],
    			buf[bi + 3],
    			buf[bi + 2],
    			buf[bi + 1],
    			buf[bi + 0]);
    }
    static long getLongB(byte[] buf, int bi) {
    	return makeLong(buf[bi + 0],
    			buf[bi + 1],
    			buf[bi + 2],
    			buf[bi + 3],
    			buf[bi + 4],
    			buf[bi + 5],
    			buf[bi + 6],
    			buf[bi + 7]
    			);
    }
    

    public static int getType(byte[] buf) {
        return ServicePacketBuffer.BUFFER.getByteOrder() == ByteOrder.BIG_ENDIAN ? getIntB(buf,TYPE_POSITION):getIntL(buf,TYPE_POSITION);
    }
}
