package com.meidusa.venus.io.packet;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;

/**
 * 
 * @author Struct, Sun Ning
 */
public abstract class AbstractServicePacket extends AbstractVenusPacket implements PacketConstant {

    private static final long serialVersionUID = 1L;
    
    /**
     * ʾݰõлʽֵΪ-1ʱлʽ>=0Ӧֵ,
     * client  Service ͨѶͨΪ-1,
     *  HSB  Serviceͨ>=0
     * 
     * @deprecated Ŀǰhsbелʽ @see {@code VenusRouterPacket#serializeType}
     */
    public byte serializeType = -1;
    
    /**
     * ڱʾݰеĶֶεԣöƱʾ
     * 00000001 ʾǷѹ
     * 00000010 ʾǷü
     */
    public byte flags;
    /**
     * ͻID
     */
    public int clientId;//4
    
    /**
     * ͻRequest ID
     */
    public long clientRequestId;//8
    
    protected void afterPacketWritten(ServicePacketBuffer buffer) {
    	super.afterPacketWritten(buffer);
        int position = buffer.getPosition();
        buffer.setPosition(11);
        buffer.writeByte(flags);
        buffer.setPosition(position);
    }

    @Override
    protected int calculatePacketSize() {
        return SERVICE_HEADER_SIZE;
    }

    @Override
    protected Class<ServicePacketBuffer> getPacketBufferClass() {
        return ServicePacketBuffer.class;
    }

    protected void writeHead(ServicePacketBuffer buffer) {
    	super.writeHead(buffer);
        buffer.writeByte(serializeType);
        buffer.writeByte(flags);
        buffer.writeInt(clientId);
        buffer.writeLong(clientRequestId);
        
        buffer.setPosition(SERVICE_HEADER_SIZE);
    }

    @Override
    protected void initHead(ServicePacketBuffer buffer) {
        super.initHead(buffer);
        serializeType = buffer.readByte();
        flags = buffer.readByte();
        clientId = buffer.readInt();
        clientRequestId = buffer.readLong();
        buffer.setPosition(SERVICE_HEADER_SIZE);
    }

    protected void readBody(ServicePacketBuffer buffer) {
    	
    }

    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
    	
    }
    
    public static long getPacketSequence(byte[] buf) {
        return ServicePacketBuffer.BUFFER.getByteOrder() == ByteOrder.BIG_ENDIAN ? getLongB(buf,SEQUENCE_POSITION):getLongL(buf,SEQUENCE_POSITION);
    }
    
    public static int getClientID(byte[] buf) {
        return ServicePacketBuffer.BUFFER.getByteOrder() == ByteOrder.BIG_ENDIAN ? getIntB(buf,CLIENTID_POSITION):getIntL(buf,CLIENTID_POSITION);
    }
    
    public static void copyHead(AbstractServicePacket source,
            AbstractServicePacket target) {
    	target.protocolVersion = source.protocolVersion;
    	target.serializeType = source.serializeType;
        target.clientId = source.clientId;
        target.clientRequestId = source.clientRequestId;
        
    }
}
