/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet;

import com.meidusa.venus.io.packet.AuthenPacket;
import com.meidusa.venus.io.packet.DummyAuthenPacket;
import com.meidusa.venus.io.packet.PasswordAuthenPacket;
import com.meidusa.venus.io.packet.PublicKeyAuthenPacket;
import java.util.HashMap;
import java.util.Map;

public class AuthenPacketFactory {
    private static AuthenPacketFactory factory = new AuthenPacketFactory();
    private Map<Byte, Class<? extends AuthenPacket>> authenMap = new HashMap<Byte, Class<? extends AuthenPacket>>();

    public static AuthenPacketFactory getInstance() {
        return factory;
    }

    private AuthenPacketFactory() {
        this.register((byte)1, DummyAuthenPacket.class);
        this.register((byte)2, PasswordAuthenPacket.class);
        this.register((byte)4, PublicKeyAuthenPacket.class);
    }

    public synchronized void register(byte type, Class<? extends AuthenPacket> clazz) {
        this.authenMap.put(type, clazz);
    }

    public AuthenPacket createAuthenPacket(byte[] message) throws Exception {
        Class<? extends AuthenPacket> clazz = this.authenMap.get(AuthenPacket.getAuthenType(message));
        AuthenPacket packet = clazz.newInstance();
        packet.init(message);
        return packet;
    }
}

