/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet;

import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import java.io.UnsupportedEncodingException;

public abstract class ServiceNofityPacket
extends AbstractServicePacket {
    private static final long serialVersionUID = 1L;
    public byte[] identityData;
    public int errorCode;
    public String errorMessage;
    public Object callbackObject;

    public ServiceNofityPacket() {
        this.type = 0x4000001;
    }

    @Override
    protected void readBody(ServicePacketBuffer buffer) {
        super.readBody(buffer);
        this.identityData = buffer.readLengthCodedBytes();
        this.errorCode = buffer.readInt();
        if (this.errorCode != 0) {
            this.errorMessage = buffer.readLengthCodedString("UTF8");
        } else {
            this.callbackObject = this.readCallBackObject(buffer);
        }
    }

    protected abstract Object readCallBackObject(ServicePacketBuffer var1);

    protected abstract void writeCallBackObject(ServicePacketBuffer var1, Object var2);

    @Override
    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        super.writeBody(buffer);
        buffer.writeLengthCodedBytes(this.identityData);
        buffer.writeInt(this.errorCode);
        if (this.errorCode != 0) {
            buffer.writeLengthCodedString(this.errorMessage, "UTF8");
        } else {
            this.writeCallBackObject(buffer, this.callbackObject);
        }
    }
}

