/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.convert;

import com.meidusa.venus.convert.CommonsBeanUtilConverter;
import com.meidusa.venus.convert.ConvertService;
import com.meidusa.venus.convert.Converter;
import com.meidusa.venus.convert.Converters;
import com.meidusa.venus.convert.DateConverter;
import com.meidusa.venus.convert.StringArrayConverter;
import com.meidusa.venus.exception.ConvertException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;

public class DefaultConvertService
implements ConvertService,
InitializingBean {
    private Converters converters = new Converters();

    public DefaultConvertService() {
        this.setUpConvert();
    }

    @Override
    public Map<String, Object> convert(Map<String, Object> raw, Map<String, Type> typeDict) throws ConvertException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Set<String> keys = raw.keySet();
        for (String key : keys) {
            if (this.isComplexType(key)) {
                String beanName = this.getBeanName(key);
                this.handleComplexType(key, raw.get(key), typeDict.get(beanName), context);
                continue;
            }
            this.handleTrivialType(key, raw, typeDict.get(key), context);
        }
        return context;
    }

    private void handleComplexType(String key, Object strValue, Type type, Map<String, Object> context) throws ConvertException {
        if (type != null) {
            Converter converter = this.converters.getConverter(type);
            Object value = converter.convert(key, strValue, type, context);
            context.put(this.getObjectKey(key), value);
        }
    }

    private void handleTrivialType(String key, Map<String, Object> raw, Type type, Map<String, Object> context) throws ConvertException {
        if (type != null) {
            Object value = type.equals(String[].class) ? this.converters.getConverter((Type)((Object)String[].class)).convert(raw.get(key), type, null) : this.converters.getConverter(type).convert(raw.get(key), type);
            context.put(key, value);
        }
    }

    private String getObjectKey(String key) {
        return key.split("\\.")[0];
    }

    @Override
    public boolean isComplexType(String key) {
        return key.contains(".");
    }

    @Override
    public String getBeanName(String key) {
        return this.getObjectKey(key);
    }

    public void setUpConvert() {
        CommonsBeanUtilConverter beanUtilConverter = new CommonsBeanUtilConverter();
        this.converters.register(Integer.TYPE, beanUtilConverter);
        this.converters.register((Type)((Object)Integer.class), beanUtilConverter);
        this.converters.register((Type)((Object)Integer[].class), beanUtilConverter);
        this.converters.register((Type)((Object)int[].class), beanUtilConverter);
        this.converters.register(Integer.TYPE, beanUtilConverter);
        this.converters.register(Short.TYPE, beanUtilConverter);
        this.converters.register((Type)((Object)Short.class), beanUtilConverter);
        this.converters.register((Type)((Object)Short[].class), beanUtilConverter);
        this.converters.register((Type)((Object)short[].class), beanUtilConverter);
        this.converters.register(Short.TYPE, beanUtilConverter);
        this.converters.register(Long.TYPE, beanUtilConverter);
        this.converters.register((Type)((Object)Long.class), beanUtilConverter);
        this.converters.register((Type)((Object)Long[].class), beanUtilConverter);
        this.converters.register((Type)((Object)long[].class), beanUtilConverter);
        this.converters.register(Long.TYPE, beanUtilConverter);
        this.converters.register((Type)((Object)Float.class), beanUtilConverter);
        this.converters.register(Float.TYPE, beanUtilConverter);
        this.converters.register((Type)((Object)Float[].class), beanUtilConverter);
        this.converters.register((Type)((Object)float[].class), beanUtilConverter);
        this.converters.register(Float.TYPE, beanUtilConverter);
        this.converters.register(Double.TYPE, beanUtilConverter);
        this.converters.register((Type)((Object)Double.class), beanUtilConverter);
        this.converters.register((Type)((Object)Double[].class), beanUtilConverter);
        this.converters.register((Type)((Object)double[].class), beanUtilConverter);
        this.converters.register(Double.TYPE, beanUtilConverter);
        this.converters.register(Byte.TYPE, beanUtilConverter);
        this.converters.register((Type)((Object)Byte.class), beanUtilConverter);
        this.converters.register((Type)((Object)Byte[].class), beanUtilConverter);
        this.converters.register((Type)((Object)byte[].class), beanUtilConverter);
        this.converters.register(Byte.TYPE, beanUtilConverter);
        this.converters.register(Boolean.TYPE, beanUtilConverter);
        this.converters.register((Type)((Object)Boolean.class), beanUtilConverter);
        this.converters.register((Type)((Object)Boolean[].class), beanUtilConverter);
        this.converters.register((Type)((Object)boolean[].class), beanUtilConverter);
        this.converters.register(Boolean.TYPE, beanUtilConverter);
        this.converters.register(Character.TYPE, beanUtilConverter);
        this.converters.register((Type)((Object)Character.class), beanUtilConverter);
        this.converters.register((Type)((Object)Character[].class), beanUtilConverter);
        this.converters.register((Type)((Object)char[].class), beanUtilConverter);
        this.converters.register(Character.TYPE, beanUtilConverter);
        this.converters.register((Type)((Object)BigDecimal.class), beanUtilConverter);
        this.converters.register((Type)((Object)BigDecimal[].class), beanUtilConverter);
        this.converters.register((Type)((Object)String.class), beanUtilConverter);
        this.converters.register((Type)((Object)String[].class), new StringArrayConverter());
        this.converters.register((Type)((Object)Date.class), new DateConverter());
        this.converters.setDefaultConverter(beanUtilConverter);
    }

    public void afterPropertiesSet() throws Exception {
        this.setUpConvert();
    }

    @Override
    public Object convert(String value, Type type) throws ConvertException {
        if (this.converters.getConverter(type) == null) {
            throw new UnsupportedOperationException("No convert found on type " + type);
        }
        return this.converters.getConverter(type).convert(value, type);
    }
}

