/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.util.Date;

public class SqlDateDeserializer
implements ObjectDeserializer {
    public static final SqlDateDeserializer instance = new SqlDateDeserializer();

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type clazz) {
        Object val = parser.parse();
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            val = new java.sql.Date(((Date)val).getTime());
        } else if (val instanceof Number) {
            val = new java.sql.Date(((Number)val).longValue());
        } else {
            if (val instanceof String) {
                String strVal = (String)val;
                if (strVal.length() == 0) {
                    return null;
                }
                long longVal = Long.parseLong(strVal);
                return (T)new java.sql.Date(longVal);
            }
            throw new JSONException("parse error : " + val);
        }
        return (T)val;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

