/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet.serialize;

import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.ServiceResponsePacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.utils.GZipUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;

public class SerializeServiceResponsePacket
extends ServiceResponsePacket {
    private static final long serialVersionUID = 1L;
    private transient Type javaType;
    private Serializer serializer;

    public SerializeServiceResponsePacket(Serializer serializer, Type javaType) {
        this.serializer = serializer;
        this.javaType = javaType;
    }

    @Override
    protected void readBody(ServicePacketBuffer buffer) {
        super.readBody(buffer);
        if (buffer.hasRemaining()) {
            byte f = (byte)(this.flags & 0x10);
            if (f == 16) {
                byte[] bts = buffer.readLengthCodedBytes();
                if (bts != null & bts.length > 0) {
                    bts = GZipUtil.decompress(bts);
                    this.result = this.serializer.decode(bts, this.javaType);
                }
            } else {
                this.result = this.serializer.decode(buffer, this.javaType);
            }
        }
    }

    @Override
    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        super.writeBody(buffer);
        if (this.result != null) {
            byte[] bts = this.serializer.encode(this.result);
            if (bts != null) {
                if (PacketConstant.AUTO_COMPRESS_SIZE > 0 && bts.length > PacketConstant.AUTO_COMPRESS_SIZE) {
                    buffer.writeLengthCodedBytes(GZipUtil.compress(bts));
                    this.flags = (byte)(this.flags | 0x10);
                } else {
                    buffer.writeLengthCodedBytes(bts);
                }
            } else {
                buffer.writeInt(0);
            }
        }
    }
}

