/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.JSONAware;
import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.JSONStreamAware;
import com.meidusa.fastjson.serializer.AppendableSerializer;
import com.meidusa.fastjson.serializer.ArraySerializer;
import com.meidusa.fastjson.serializer.AutowiredObjectSerializer;
import com.meidusa.fastjson.serializer.CharsetSerializer;
import com.meidusa.fastjson.serializer.CollectionSerializer;
import com.meidusa.fastjson.serializer.DateSerializer;
import com.meidusa.fastjson.serializer.EnumSerializer;
import com.meidusa.fastjson.serializer.ExceptionSerializer;
import com.meidusa.fastjson.serializer.JSONAwareSerializer;
import com.meidusa.fastjson.serializer.JSONStreamAwareSerializer;
import com.meidusa.fastjson.serializer.ListSerializer;
import com.meidusa.fastjson.serializer.MapSerializer;
import com.meidusa.fastjson.serializer.NameFilter;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.PropertyFilter;
import com.meidusa.fastjson.serializer.SerializeConfig;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastjson.serializer.SerializerFeature;
import com.meidusa.fastjson.serializer.StringSerializer;
import com.meidusa.fastjson.serializer.TimeZoneSerializer;
import com.meidusa.fastjson.serializer.ValueFilter;
import com.meidusa.fastjson.util.ServiceLoader;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class JSONSerializer {
    private final SerializeConfig config;
    private final SerializeWriter out;
    private List<PropertyFilter> propertyFilters = null;
    private List<ValueFilter> valueFilters = null;
    private List<NameFilter> nameFilters = null;
    private int indentCount = 0;
    private String indent = "\t";

    public List<ValueFilter> getValueFilters() {
        if (this.valueFilters == null) {
            this.valueFilters = new ArrayList<ValueFilter>();
        }
        return this.valueFilters;
    }

    public List<ValueFilter> getValueFiltersDirect() {
        return this.valueFilters;
    }

    public int getIndentCount() {
        return this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    public void decrementIdent() {
        --this.indentCount;
    }

    public void println() {
        this.out.write('\n');
        for (int i = 0; i < this.indentCount; ++i) {
            this.out.write(this.indent);
        }
    }

    public List<NameFilter> getNameFilters() {
        if (this.nameFilters == null) {
            this.nameFilters = new ArrayList<NameFilter>();
        }
        return this.nameFilters;
    }

    public List<NameFilter> getNameFiltersDirect() {
        return this.nameFilters;
    }

    public List<PropertyFilter> getPropertyFilters() {
        if (this.propertyFilters == null) {
            this.propertyFilters = new ArrayList<PropertyFilter>();
        }
        return this.propertyFilters;
    }

    public List<PropertyFilter> getPropertyFiltersDirect() {
        return this.propertyFilters;
    }

    public JSONSerializer() {
        this(new SerializeWriter(), SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeWriter out) {
        this(out, SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeConfig mapping) {
        this(new SerializeWriter(), mapping);
    }

    public JSONSerializer(SerializeWriter out, SerializeConfig config) {
        this.out = out;
        this.config = config;
    }

    public SerializeWriter getWriter() {
        return this.out;
    }

    public String toString() {
        return this.out.toString();
    }

    public void config(SerializerFeature feature, boolean state) {
        this.out.config(feature, state);
    }

    public boolean isEnabled(SerializerFeature feature) {
        return this.out.isEnabled(feature);
    }

    public void writeNull() {
        this.out.writeNull();
    }

    public SerializeConfig getMapping() {
        return this.config;
    }

    public static final void write(Writer out, Object object) {
        SerializeWriter writer = new SerializeWriter();
        try {
            JSONSerializer serializer = new JSONSerializer(writer);
            serializer.write(object);
            writer.writeTo(out);
        }
        catch (IOException ex) {
            throw new JSONException(ex.getMessage(), ex);
        }
        finally {
            writer.close();
        }
    }

    public static final void write(SerializeWriter out, Object object) {
        JSONSerializer serializer = new JSONSerializer(out);
        serializer.write(object);
    }

    public final void write(Object object) {
        try {
            if (object == null) {
                this.out.writeNull();
                return;
            }
            Class<?> clazz = object.getClass();
            ObjectSerializer writer = this.getObjectWriter(clazz);
            writer.write(this, object);
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public final void writeWithFormat(Object object, String format) {
        if (object instanceof Date) {
            String text = new SimpleDateFormat(format).format((Date)object);
            this.out.writeString(text);
            return;
        }
        this.write(object);
    }

    public final void write(String text) {
        StringSerializer.instance.write(this, text);
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        ObjectSerializer writer = (ObjectSerializer)this.config.get(clazz);
        if (writer == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (AutowiredObjectSerializer autowired : ServiceLoader.load(AutowiredObjectSerializer.class, classLoader)) {
                for (Type forType : autowired.getAutowiredFor()) {
                    this.config.put(forType, autowired);
                }
            }
            writer = (ObjectSerializer)this.config.get(clazz);
        }
        if (writer == null) {
            if (Map.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, MapSerializer.instance);
            } else if (List.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, ListSerializer.instance);
            } else if (Collection.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, CollectionSerializer.instance);
            } else if (Date.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, DateSerializer.instance);
            } else if (JSONAware.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, JSONAwareSerializer.instance);
            } else if (JSONStreamAware.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, JSONStreamAwareSerializer.instance);
            } else if (clazz.isEnum()) {
                this.config.put(clazz, EnumSerializer.instance);
            } else if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                ObjectSerializer compObjectSerializer = this.getObjectWriter(componentType);
                this.config.put(clazz, new ArraySerializer(compObjectSerializer));
            } else if (Throwable.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, new ExceptionSerializer(clazz));
            } else if (TimeZone.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, TimeZoneSerializer.instance);
            } else if (Appendable.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, AppendableSerializer.instance);
            } else if (Charset.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, CharsetSerializer.instance);
            } else {
                this.config.put(clazz, this.config.createJavaBeanSerializer(clazz));
            }
            writer = (ObjectSerializer)this.config.get(clazz);
        }
        return writer;
    }
}

