/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastjson.serializer.SerializerFeature;
import java.io.IOException;

public class IntegerSerializer
implements ObjectSerializer {
    public static IntegerSerializer instance = new IntegerSerializer();

    @Override
    public void write(JSONSerializer serializer, Object object) throws IOException {
        SerializeWriter out = serializer.getWriter();
        Number value = (Number)object;
        if (value == null) {
            if (out.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
                out.write('0');
            } else {
                out.writeNull();
            }
            return;
        }
        out.writeInt(value.intValue());
    }
}

