/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser;

import com.meidusa.fastjson.JSONArray;
import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.JSONObject;
import com.meidusa.fastjson.parser.Feature;
import com.meidusa.fastjson.parser.JSONLexer;
import com.meidusa.fastjson.parser.JSONScanner;
import com.meidusa.fastjson.parser.JSONToken;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public abstract class AbstractJSONParser {
    public abstract void parseObject(Map var1);

    public JSONObject parseObject() {
        JSONObject object = new JSONObject();
        this.parseObject(object);
        return object;
    }

    public final void parseArray(Collection array) {
        JSONLexer lexer = this.getLexer();
        if (lexer.token() != 14) {
            throw new JSONException("syntax error, expect [, actual " + JSONToken.name(lexer.token()));
        }
        lexer.nextToken(4);
        while (true) {
            Object value;
            if (this.isEnabled(Feature.AllowArbitraryCommas)) {
                while (lexer.token() == 16) {
                    lexer.nextToken();
                }
            }
            switch (lexer.token()) {
                case 2: {
                    value = lexer.integerValue();
                    lexer.nextToken(16);
                    break;
                }
                case 3: {
                    value = lexer.isEnabled(Feature.UseBigDecimal) ? lexer.decimalValue() : Double.valueOf(lexer.doubleValue());
                    lexer.nextToken(16);
                    break;
                }
                case 4: {
                    String stringLiteral = lexer.stringVal();
                    lexer.nextToken(16);
                    if (lexer.isEnabled(Feature.AllowISO8601DateFormat)) {
                        JSONScanner iso8601Lexer = new JSONScanner(stringLiteral);
                        if (iso8601Lexer.scanISO8601DateIfMatch()) {
                            value = iso8601Lexer.getCalendar().getTime();
                            break;
                        }
                        value = stringLiteral;
                        break;
                    }
                    value = stringLiteral;
                    break;
                }
                case 6: {
                    value = Boolean.TRUE;
                    lexer.nextToken(16);
                    break;
                }
                case 7: {
                    value = Boolean.FALSE;
                    lexer.nextToken(16);
                    break;
                }
                case 12: {
                    JSONObject object = new JSONObject();
                    this.parseObject(object);
                    value = object;
                    break;
                }
                case 14: {
                    JSONArray items = new JSONArray();
                    this.parseArray(items);
                    value = items;
                    break;
                }
                case 8: {
                    value = null;
                    lexer.nextToken(4);
                    break;
                }
                case 15: {
                    lexer.nextToken(16);
                    return;
                }
                default: {
                    value = this.parse();
                }
            }
            array.add(value);
            if (lexer.token() != 16) continue;
            lexer.nextToken(4);
        }
    }

    public Object parse() {
        JSONLexer lexer = this.getLexer();
        switch (lexer.token()) {
            case 14: {
                JSONArray array = new JSONArray();
                this.parseArray(array);
                return array;
            }
            case 12: {
                JSONObject object = new JSONObject();
                this.parseObject(object);
                return object;
            }
            case 2: {
                Number intValue = lexer.integerValue();
                lexer.nextToken();
                return intValue;
            }
            case 3: {
                Number value = this.isEnabled(Feature.UseBigDecimal) ? lexer.decimalValue() : Double.valueOf(lexer.doubleValue());
                lexer.nextToken();
                return value;
            }
            case 4: {
                JSONScanner iso8601Lexer;
                String stringLiteral = lexer.stringVal();
                lexer.nextToken(16);
                if (lexer.isEnabled(Feature.AllowISO8601DateFormat) && (iso8601Lexer = new JSONScanner(stringLiteral)).scanISO8601DateIfMatch()) {
                    return iso8601Lexer.getCalendar().getTime();
                }
                return stringLiteral;
            }
            case 8: {
                lexer.nextToken();
                return null;
            }
            case 6: {
                lexer.nextToken();
                return Boolean.TRUE;
            }
            case 7: {
                lexer.nextToken();
                return Boolean.FALSE;
            }
            case 9: {
                lexer.nextToken(18);
                if (lexer.token() != 18) {
                    throw new JSONException("syntax error");
                }
                lexer.nextToken(10);
                this.accept(10);
                long time = lexer.integerValue().longValue();
                this.accept(2);
                this.accept(11);
                return new Date(time);
            }
            case 20: {
                if (!lexer.isBlankInput()) break;
                return null;
            }
        }
        throw new JSONException("TODO " + JSONToken.name(lexer.token()) + " " + lexer.stringVal());
    }

    public void config(Feature feature, boolean state) {
        this.getLexer().config(feature, state);
    }

    public boolean isEnabled(Feature feature) {
        return this.getLexer().isEnabled(feature);
    }

    public abstract JSONLexer getLexer();

    public final void accept(int token) {
        JSONLexer lexer = this.getLexer();
        if (lexer.token() != token) {
            throw new JSONException("syntax error, expect " + JSONToken.name(token) + ", actual " + JSONToken.name(lexer.token()));
        }
        lexer.nextToken();
    }

    public void close() {
        JSONLexer lexer = this.getLexer();
        if (this.isEnabled(Feature.AutoCloseSource) && !lexer.isEOF()) {
            throw new JSONException("not close json text, token : " + JSONToken.name(lexer.token()));
        }
    }
}

