/*
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details. 
 * 	You should have received a copy of the GNU General Public License along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package com.meidusa.venus.io.packet;


public interface PacketConstant {
	
	public static final String VENUS_CLIENT = "VENUS-JAVA-CLIENT";
	/**
	 * Э汾
	 */
	public static final short PROTOCOL_VERSION = 2;
	
	/**
	 * venus 汾
	 */
	public static final String VENUS_VERSION = "2.0.5-BETA";
	
	/**
	 * Эͷ
	 */
    public static final int SERVICE_HEADER_SIZE = 24;
    
    /**
     * Typeݰеʼλ
     */
    public static final int TYPE_POSITION = 6;
    
    /**
     * ͻIDλ
     */
    public static final int CLIENTID_POSITION = 12;
    
    /**
     * ϵкλ
     */
    public static final int SEQUENCE_POSITION = 16;
    
    public static final byte[] SERVICE_HEADER_PAD = new byte[SERVICE_HEADER_SIZE];
    
    public static final int PACKET_TYPE_PING 						= 0x01000001;
    public static final int PACKET_TYPE_PONG 						= 0x01000002;
    
    public static final int PACKET_TYPE_SERVICE_REQUEST 			= 0x02000001;
    public static final int PACKET_TYPE_SERVICE_RESPONSE 			= 0x02000002;
    
    public static final int PACKET_TYPE_HANDSHAKE 					= 0x03000001;
    
    public static final int PACKET_TYPE_AUTHEN					 	= 0x03100000;
    
    /**
     * ʶ֤
     */
    public static final byte AUTHEN_TYPE_DUMMY			 			= 0x01 << 0;
    
    /**
     * ʶû뷽ʽ֤
     */
    public static final byte AUTHEN_TYPE_PASSWORD 					= 0x01 << 1;
    
    /**
     * ʶPKIʽ֤2.0.0-BETA汾δʵ֣
     */
    public static final byte AUTHEN_TYPE_PKI			 			= 0x01 << 2;
    
    public static final int PACKET_TYPE_NOTIFY_PUBLISH 				= 0x04000001;
    
    public static final int PACKET_TYPE_NOTIFY_SUBSCRIBE 			= 0x04000002;
    
    public static final int PACKET_TYPE_OK							= 0x00000001;
    public static final int PACKET_TYPE_ERROR 						= 0xFFFFFFFF;
    
    public static final String PACKET_CHARSET = "UTF8";
    
    public static final byte CONTENT_TYPE_JSON = 0x00;
    public static final byte CONTENT_TYPE_BSON = 0x01;
    public static final byte CONTENT_TYPE_OBJECT = 0x02;
    
    public static final int AUTH_CURRENT_SUPPORT = AUTHEN_TYPE_DUMMY | AUTHEN_TYPE_PASSWORD;
    
    public static final int AUTO_COMPRESS_SIZE = Integer.getInteger("venus.compress.auto", -1);
    
    /**
     * GZIPѹ
     */
    public static final byte CAPABILITY_GZIP = 1 << 4;
    
    
    /**
     * ͻϢ
     */
    public static final int CAPABILITY_LISTENER = 1 << 7;
    
    public static final int CAPABILITIES = CAPABILITY_GZIP;
}
