/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.JSONLexer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import com.meidusa.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigInteger;

public class BigIntegerDeserializer
implements ObjectDeserializer {
    public static final BigIntegerDeserializer instance = new BigIntegerDeserializer();

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type clazz) {
        return BigIntegerDeserializer.deserialze(parser);
    }

    public static <T> T deserialze(DefaultExtJSONParser parser) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 2) {
            String val = lexer.numberString();
            lexer.nextToken(16);
            return (T)new BigInteger(val);
        }
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        return (T)TypeUtils.castToBigInteger(value);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

