/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.exception;

import com.meidusa.toolkit.common.bean.PureJavaReflectionProvider;
import com.meidusa.toolkit.common.bean.ReflectionProvider;
import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.venus.annotations.ExceptionCode;
import com.meidusa.venus.annotations.RemoteException;
import com.meidusa.venus.digester.DigesterRuleParser;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.VenusConfigException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.exception.xml.ExceptionConfig;
import com.meidusa.venus.util.ClasspathAnnotationScanner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class XmlVenusExceptionFactory
implements VenusExceptionFactory {
    private static Logger logger = LoggerFactory.getLogger(XmlVenusExceptionFactory.class);
    private static ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private static boolean SCANNED = false;
    private static Map<Integer, ExceptionConfig> codeMap = new HashMap<Integer, ExceptionConfig>();
    private static Map<Class, ExceptionConfig> classMap = new HashMap<Class, ExceptionConfig>();
    private static ReflectionProvider reflectionProvider;
    private String[] configFiles;

    static {
        Map exceptionCodeMap = ClasspathAnnotationScanner.find(Exception.class, ExceptionCode.class);
        for (Map.Entry entry : exceptionCodeMap.entrySet()) {
            ExceptionConfig config = new ExceptionConfig();
            config.setErrorCode(((ExceptionCode)entry.getValue()).errorCode());
            config.setType((Class)entry.getKey());
            codeMap.put(config.getErrorCode(), config);
            classMap.put((Class)entry.getKey(), config);
        }
        Map rMap = ClasspathAnnotationScanner.find(Exception.class, RemoteException.class);
        for (Map.Entry entry : rMap.entrySet()) {
            ExceptionConfig config = new ExceptionConfig();
            config.setErrorCode(((RemoteException)entry.getValue()).errorCode());
            config.setType((Class)entry.getKey());
            codeMap.put(config.getErrorCode(), config);
            classMap.put((Class)entry.getKey(), config);
        }
        reflectionProvider = PureJavaReflectionProvider.getInstance();
    }

    public String[] getConfigFiles() {
        return this.configFiles;
    }

    public void setConfigFiles(String[] configFiles) {
        this.configFiles = configFiles;
    }

    @Override
    public void addException(Class<? extends CodedException> clazz) {
        CodedException exception = (CodedException)reflectionProvider.newInstance(clazz);
        ExceptionConfig config = new ExceptionConfig();
        config.setErrorCode(exception.getErrorCode());
        config.setType(clazz);
        codeMap.put(config.getErrorCode(), config);
        classMap.put(clazz, config);
    }

    @Override
    public Exception getException(int errcode, String message) {
        ExceptionConfig config = codeMap.get(errcode);
        if (config == null) {
            return new DefaultVenusException(errcode, message);
        }
        Constructor<?>[] constructors = null;
        try {
            Constructor<?>[] constructorArray = constructors = config.getType().getConstructors();
            int n = constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                if (Modifier.isPublic(constructor.getModifiers())) {
                    Class<?>[] type = constructor.getParameterTypes();
                    if (type.length == 1) {
                        if (type[0] == String.class) {
                            try {
                                return (Exception)constructor.newInstance(message);
                            }
                            catch (Exception e) {
                                logger.error("create exception instance error", (Throwable)e);
                                return new DefaultVenusException(errcode, "create exception instance error", e);
                            }
                        }
                    } else if (type.length == 2) {
                        if (type[0] == String.class && type[1] == Throwable.class) {
                            try {
                                Object[] objectArray = new Object[2];
                                objectArray[0] = message;
                                return (Exception)constructor.newInstance(objectArray);
                            }
                            catch (Exception e) {
                                logger.error("create exception instance error", (Throwable)e);
                                return new DefaultVenusException(errcode, "create exception instance error", e);
                            }
                        }
                        if (type[0] == Throwable.class && type[1] == String.class) {
                            try {
                                Object[] objectArray = new Object[2];
                                objectArray[1] = message;
                                return (Exception)constructor.newInstance(objectArray);
                            }
                            catch (Exception e) {
                                logger.error("create exception instance error", (Throwable)e);
                                return new DefaultVenusException(errcode, "create exception instance error", e);
                            }
                        }
                    } else if (type.length == 0) {
                        try {
                            return (Exception)constructor.newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            logger.error("create exception instance error", (Throwable)e);
                            return new DefaultVenusException(errcode, "create exception instance error", e);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (SecurityException e) {
            logger.error("exception new instance error", (Throwable)e);
        }
        return new DefaultVenusException(errcode, message);
    }

    @Override
    public int getErrorCode(Class<? extends Throwable> clazz) {
        ExceptionConfig config = classMap.get(clazz);
        if (config != null) {
            return config.getErrorCode();
        }
        return 0;
    }

    public synchronized void doScanExtension() {
        if (SCANNED) {
            return;
        }
        SCANNED = true;
        try {
            Resource[] resources;
            String packageSearchPath = "classpath*:/META-INF/venus.exception.xml";
            Resource[] resourceArray = resources = resourcePatternResolver.getResources(packageSearchPath);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray[n2];
                if (logger.isInfoEnabled()) {
                    logger.info("Scanning " + resource);
                }
                if (resource.isReadable()) {
                    this.load(resource);
                } else if (logger.isInfoEnabled()) {
                    logger.info("Ignored because not readable: " + resource);
                }
                ++n2;
            }
        }
        catch (IOException ex) {
            logger.error("read venus exception xml error", (Throwable)ex);
        }
    }

    public void load(Resource resource) {
        URL eis = this.getClass().getResource("VenusSystemExceptionRule.xml");
        if (eis == null) {
            throw new VenusConfigException("classpath resource 'VenusSystemExceptionRule.xml' not found");
        }
        FromXmlRuleSet ruleSet = new FromXmlRuleSet(eis, (org.apache.commons.digester.xmlrules.DigesterRuleParser)new DigesterRuleParser());
        Digester digester = new Digester();
        digester.addRuleSet((RuleSet)ruleSet);
        try {
            try {
                List list = (List)digester.parse(resource.getInputStream());
                for (ExceptionConfig config : list) {
                    if (config.getErrorCode() == 0) {
                        Exception exception = (Exception)reflectionProvider.newInstance(config.getType());
                        if (exception instanceof CodedException) {
                            config.setErrorCode(((CodedException)((Object)exception)).getErrorCode());
                        } else {
                            throw new VenusConfigException("exception type=" + config.getType() + " must implement CodedException or errorCode must not be null");
                        }
                    }
                    codeMap.put(config.getErrorCode(), config);
                    classMap.put(config.getType(), config);
                }
            }
            catch (Exception e) {
                try {
                    logger.error("parser " + resource.getURL() + " error", (Throwable)e);
                }
                catch (IOException e1) {
                    logger.error("parser " + resource.getFilename() + " error", (Throwable)e);
                }
                digester.clear();
            }
        }
        finally {
            digester.clear();
        }
    }

    public void init() {
        this.doScanExtension();
        if (this.configFiles == null) {
            return;
        }
        String[] stringArray = this.configFiles;
        int n = this.configFiles.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                String configFile = stringArray[n2];
                configFile = (String)ConfigUtil.filter((String)configFile);
                configFile = configFile.trim();
                URL eis = this.getClass().getResource("VenusSystemExceptionRule.xml");
                if (eis == null) {
                    throw new VenusConfigException("classpath resource 'VenusSystemExceptionRule.xml' not found");
                }
                FromXmlRuleSet ruleSet = new FromXmlRuleSet(eis, (org.apache.commons.digester.xmlrules.DigesterRuleParser)new DigesterRuleParser());
                Digester digester = new Digester();
                digester.addRuleSet((RuleSet)ruleSet);
                try {
                    try {
                        InputStream is = null;
                        if (configFile.startsWith("classpath:")) {
                            configFile = configFile.substring("classpath:".length());
                            is = this.getClass().getClassLoader().getResourceAsStream(configFile);
                        } else {
                            is = new FileInputStream(new File(configFile));
                        }
                        List list = (List)digester.parse(is);
                        for (ExceptionConfig config : list) {
                            if (config.getErrorCode() == 0) {
                                Exception exception = (Exception)reflectionProvider.newInstance(config.getType());
                                if (exception instanceof CodedException) {
                                    config.setErrorCode(((CodedException)((Object)exception)).getErrorCode());
                                } else {
                                    throw new VenusConfigException("exception type=" + config.getType() + " must implement CodedException or errorCode must not be null");
                                }
                            }
                            codeMap.put(config.getErrorCode(), config);
                            classMap.put(config.getType(), config);
                        }
                    }
                    catch (Exception e) {
                        logger.error("parser VenusSystemExceptionRule.xml error", (Throwable)e);
                        digester.clear();
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    digester.clear();
                    throw throwable;
                }
                digester.clear();
            }
            ++n2;
        }
    }
}

