/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.exception;

import com.meidusa.toolkit.common.bean.PureJavaReflectionProvider;
import com.meidusa.toolkit.common.bean.ReflectionProvider;
import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.venus.digester.DigesterRuleParser;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.exception.xml.ExceptionConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.apache.log4j.Logger;

public class XmlVenusExceptionFactory
implements VenusExceptionFactory {
    private static Logger logger = Logger.getLogger(XmlVenusExceptionFactory.class);
    private Map<Integer, ExceptionConfig> codeMap = new HashMap<Integer, ExceptionConfig>();
    private Map<Class, ExceptionConfig> classMap = new HashMap<Class, ExceptionConfig>();
    private static ReflectionProvider reflectionProvider = PureJavaReflectionProvider.getInstance();
    private String[] configFiles;

    public String[] getConfigFiles() {
        return this.configFiles;
    }

    public void setConfigFiles(String[] configFiles) {
        this.configFiles = configFiles;
    }

    @Override
    public void addException(Class<? extends CodedException> clazz) {
        CodedException exception = (CodedException)reflectionProvider.newInstance(clazz);
        ExceptionConfig config = new ExceptionConfig();
        config.setErrorCode(exception.getErrorCode());
        config.setType(clazz);
        this.codeMap.put(config.getErrorCode(), config);
        this.classMap.put(clazz, config);
    }

    @Override
    public Exception getException(int errcode, String message) {
        ExceptionConfig config = this.codeMap.get(errcode);
        if (config == null) {
            return new DefaultVenusException(errcode, message);
        }
        Constructor<?>[] constructors = null;
        try {
            for (Constructor<?> constructor : constructors = config.getType().getConstructors()) {
                if (!Modifier.isPublic(constructor.getModifiers())) continue;
                Class<?>[] type = constructor.getParameterTypes();
                if (type.length == 1) {
                    if (type[0] != String.class) continue;
                    try {
                        return (Exception)constructor.newInstance(message);
                    }
                    catch (Exception e) {
                        logger.error((Object)"create exception instance error", (Throwable)e);
                        return new DefaultVenusException(errcode, "create exception instance error", e);
                    }
                }
                if (type.length == 2) {
                    if (type[0] == String.class && type[1] == Throwable.class) {
                        try {
                            return (Exception)constructor.newInstance(message, null);
                        }
                        catch (Exception e) {
                            logger.error((Object)"create exception instance error", (Throwable)e);
                            return new DefaultVenusException(errcode, "create exception instance error", e);
                        }
                    }
                    if (type[0] != Throwable.class || type[1] != String.class) continue;
                    try {
                        return (Exception)constructor.newInstance(null, message);
                    }
                    catch (Exception e) {
                        logger.error((Object)"create exception instance error", (Throwable)e);
                        return new DefaultVenusException(errcode, "create exception instance error", e);
                    }
                }
                if (type.length != 0) continue;
                try {
                    return (Exception)constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    logger.error((Object)"create exception instance error", (Throwable)e);
                    return new DefaultVenusException(errcode, "create exception instance error", e);
                }
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return new DefaultVenusException(errcode, message);
    }

    @Override
    public int getErrorCode(Class<? extends Throwable> clazz) {
        ExceptionConfig config = this.classMap.get(clazz);
        if (config != null) {
            return config.getErrorCode();
        }
        return 0;
    }

    public void init() {
        FromXmlRuleSet ruleSet = new FromXmlRuleSet(this.getClass().getResource("VenusSystemExceptionRule.xml"), (org.apache.commons.digester.xmlrules.DigesterRuleParser)new DigesterRuleParser());
        for (String configFile : this.configFiles) {
            configFile = (String)ConfigUtil.filter((String)configFile);
            Digester digester = new Digester();
            digester.addRuleSet((RuleSet)ruleSet);
            try {
                InputStream is = null;
                if (configFile.startsWith("classpath:")) {
                    configFile = configFile.substring("classpath:".length());
                    is = this.getClass().getClassLoader().getResourceAsStream(configFile);
                } else {
                    is = new FileInputStream(new File(configFile));
                }
                List list = (List)digester.parse(is);
                for (ExceptionConfig config : list) {
                    this.codeMap.put(config.getErrorCode(), config);
                    this.classMap.put(config.getType(), config);
                }
            }
            catch (Exception e) {
                logger.error((Object)"parser VenusSystemExceptionRule.xml error", (Throwable)e);
            }
        }
    }
}

