/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.web.runtime;

import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.toolkit.common.runtime.util.SystemPropertyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplication {
    private Logger logger = LoggerFactory.getLogger(WebApplication.class);

    protected static void setUpSystemProperties() {
        File projectHome = new File(SystemPropertyUtils.resolvePlaceholders((String)System.getProperty("project.home", ".")));
        System.setProperty("project.home", projectHome.getAbsolutePath());
    }

    public void setUp() throws Exception {
        this.logger.warn(WebApplication.class + "  startup..");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                WebApplication.this.logger.warn(WebApplication.this.getClass() + "  shutdown..");
            }
        });
        WebApplication.setUpSystemProperties();
    }

    public static void main(String[] args) throws Exception {
        WebApplication.setUpSystemProperties();
        Properties jvm = new Properties(System.getProperties());
        File jvmFile = new File(ConfigUtil.filter((String)"${project.home}/jvm.properties", (Properties)System.getProperties()));
        if (jvmFile.exists()) {
            jvm.load(new FileInputStream(jvmFile));
        }
        File projectOut = new File(ConfigUtil.filter((String)"${project.output:${PROJECT_OUTPUT}}", (Properties)jvm));
        System.setProperty("project.output", projectOut.getAbsolutePath());
        jvm.setProperty("project.output", projectOut.getAbsolutePath());
        System.setProperty("LOG_HOME", ConfigUtil.filter((String)"${LOG_HOME}", (Properties)jvm));
        String logbackConf = jvm.getProperty("logback.configurationFile", "${project.home}/conf/logback.xml");
        logbackConf = ConfigUtil.filter((String)logbackConf, (Properties)jvm);
        File logbackFile = new File(logbackConf);
        if (logbackFile.exists()) {
            System.setProperty("logback.configurationFile", logbackConf);
            System.out.println("Log system load configuration form " + logbackConf);
            System.setProperty("logback.configurationFile", logbackConf);
        } else {
            String log4jConf = jvm.getProperty("log4j.configuration", "${project.home}/conf/log4j.xml");
            File log4jFile = new File(log4jConf = ConfigUtil.filter((String)log4jConf, (Properties)jvm));
            if (!log4jFile.exists()) {
                log4jConf = jvm.getProperty("log4j.configuration", "${project.home}/conf/log4j.properties");
                log4jConf = ConfigUtil.filter((String)log4jConf, (Properties)jvm);
                log4jFile = new File(log4jConf);
            }
            if (log4jFile.exists()) {
                System.setProperty("log4j.configuration", log4jConf);
                System.out.println("Log system load configuration form " + log4jConf);
            }
        }
        WebApplication app = new WebApplication();
        Logger logger = app.logger;
        try {
            app.setUp();
        }
        catch (Exception e) {
            logger.error("run application error", (Throwable)e);
            e.printStackTrace();
        }
        String webappDirLocation = "src/main/webapp/";
        Tomcat tomcat = new Tomcat();
        String webPort = jvm.getProperty("SERVER_PORT", "8080");
        if (webPort == null || webPort.isEmpty()) {
            webPort = "8080";
        }
        tomcat.setPort(Integer.valueOf(webPort).intValue());
        File webapp = new File(webappDirLocation);
        if (!webapp.exists()) {
            webapp = new File(ConfigUtil.filter((String)"${project.home}", (Properties)System.getProperties()), "webapp");
        }
        StandardContext ctx = (StandardContext)tomcat.addWebapp(jvm.getProperty("SERVER_PATH", "/"), webapp.getAbsolutePath());
        tomcat.start();
        System.out.println("configuring web with basedir: " + webapp.getAbsolutePath());
        System.out.println("configuring web http port: " + webPort);
        System.out.println("configuring web context path: " + jvm.getProperty("SERVER_PATH", "/"));
        tomcat.getServer().await();
    }
}

