package com.meidusa.toolkit.web.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.toolkit.common.runtime.util.SystemPropertyUtils;

public class WebApplication {
	/**
	 * ÷Ǿ̬,δҵӦ֮ǰȳʼ,޷ָý־
	 */
	private Logger logger = LoggerFactory.getLogger(WebApplication.class);

	protected static void setUpSystemProperties() {
		File projectHome = new File(
				SystemPropertyUtils.resolvePlaceholders(System.getProperty(
						"project.home", ".")));
		System.setProperty("project.home", projectHome.getAbsolutePath());
	}

	public void setUp() throws Exception {
		logger.warn(WebApplication.class + "  startup..");
		Runtime.getRuntime().addShutdownHook(new Thread() {
			public void run() {
				logger.warn(WebApplication.this.getClass() + "  shutdown..");
			}
		});
		setUpSystemProperties();

	}

	public static void main(String[] args) throws Exception {
		setUpSystemProperties();
		Properties jvm = new Properties(System.getProperties());
		File jvmFile = new File(ConfigUtil.filter("${project.home}/jvm.properties", System.getProperties()));
		if(jvmFile.exists()){
			jvm.load(new FileInputStream(jvmFile));
		}
		
		File projectOut = new File(ConfigUtil.filter("${project.output:${PROJECT_OUTPUT}}", jvm));
		System.setProperty("project.output", projectOut.getAbsolutePath());
		jvm.setProperty("project.output", projectOut.getAbsolutePath());
		
		System.setProperty("LOG_HOME", ConfigUtil.filter("${LOG_HOME}",jvm));
		
		__INIT_LOG: {
			String logbackConf = jvm.getProperty(
					"logback.configurationFile",
					"${project.home}/conf/logback.xml");
			logbackConf = ConfigUtil.filter(logbackConf, jvm);

			File logbackFile = new File(logbackConf);
			if (logbackFile.exists()) {
				System.setProperty("logback.configurationFile", logbackConf);
				System.out.println("Log system load configuration form "+ logbackConf);
				System.setProperty("logback.configurationFile", logbackConf);
				break __INIT_LOG;
			}

			String log4jConf = jvm.getProperty("log4j.configuration","${project.home}/conf/log4j.xml");
			log4jConf = ConfigUtil.filter(log4jConf, jvm);
			File log4jFile = new File(log4jConf);

			if (!log4jFile.exists()) {
				log4jConf = jvm.getProperty("log4j.configuration","${project.home}/conf/log4j.properties");
				log4jConf = ConfigUtil.filter(log4jConf, jvm);
				log4jFile = new File(log4jConf);
			}

			if (log4jFile.exists()) {
				System.setProperty("log4j.configuration", log4jConf);
				System.out.println("Log system load configuration form "+ log4jConf);

				break __INIT_LOG;
			}
		}

		WebApplication app = new WebApplication();
		Logger logger = app.logger;
		try {

			app.setUp();
		} catch (Exception e) {
			logger.error("run application error", e);

			// ̨
			e.printStackTrace();
		}

		String webappDirLocation = "src/main/webapp/";
		Tomcat tomcat = new Tomcat();

		// The port that we should run on can be set into an environment
		// variable
		// Look for that variable and default to 8080 if it isn't there.
		String webPort = jvm.getProperty("SERVER_PORT","8080");
		if (webPort == null || webPort.isEmpty()) {
			webPort = "8080";
		}

		tomcat.setPort(Integer.valueOf(webPort));
		
		File webapp = new File(webappDirLocation);
		if (!webapp.exists()) {
			webapp = new File(ConfigUtil.filter("${project.home}",
					System.getProperties()), "webapp");
		}

		StandardContext ctx = (StandardContext) tomcat.addWebapp(jvm.getProperty("SERVER_PATH","/"),
				webapp.getAbsolutePath());
		// Declare an alternative location for your "WEB-INF/classes" dir
		// Servlet 3.0 annotation will work
		/*
		 * File additionWebInfClasses = new File("target/classes");
		 * WebResourceRoot resources = new StandardRoot(ctx);
		 * resources.addPreResources(new DirResourceSet(resources,
		 * "/WEB-INF/classes", additionWebInfClasses.getAbsolutePath(), "/"));
		 */
		// ctx.setResources(resources);
		
		//ctx.setWorkDir(ConfigUtil.filter("${project.output}", jvm));
		tomcat.start();
		
		System.out.println("configuring web with basedir: "+ webapp.getAbsolutePath());
		System.out.println("configuring web http port: "+ webPort);
		System.out.println("configuring web context path: "+ jvm.getProperty("SERVER_PATH","/"));
		
		tomcat.getServer().await();
	}
}
