package com.meidusa.toolkit.net.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/*
 * <b> The Packet Header </b>
 * 
 * <pre>
 * Bytes                 Name
 *  -----                 ----
 * </p>
 * </pre>
 * 
 * */
public abstract class AbstractPacketMetaData {
	private static byte[] HEAD_PAD = null;

	public byte[] getHeadPad() {
		if (HEAD_PAD == null) {
			HEAD_PAD = new byte[this.getHeaderSize()];
		}
		return HEAD_PAD;
	}

	public abstract int getHeaderSize();

	/**
	 * decode length
	 * @param _buffer
	 * @return
	 */
	protected int decodeLength(ByteBuffer _buffer) {
		_buffer.rewind();

		/**
		 * 数据部分＋包头=整个数据包长度
		 */
		int length = _buffer.getInt();
		return length;
	}

	/**
	 * 需要与<code>AbstractPacketBuffer.getByteOrder()</code> 保持一致 
	 * @see AbstractPacketBuffer#getByteOrder()
	 * 
	 * @return
	 */
	public ByteOrder getByteOrder() {
		return ByteOrder.BIG_ENDIAN;
	}
}
