package com.meidusa.toolkit.net.factory;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import com.meidusa.toolkit.net.AuthingableBackendConnection;
import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.util.CreateConnectionException;

public abstract class AuthingableBackendConnectionFactory extends
		BackendConnectionFactory {
	
	public BackendConnection make() throws IOException {
		BackendConnection c = super.make();
		AuthingableBackendConnection conn = (AuthingableBackendConnection) c;
		if(!conn.waitForAuthenticate(5,TimeUnit.SECONDS)){
			conn.close();
			throw new CreateConnectionException(conn.isFinishConnect()?"authenticate error to "+c.getHost()+":"+c.getPort():"cannot connect to "+c.getHost()+":"+c.getPort());
		}
		return conn;
	}

}
