package com.meidusa.toolkit.net;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import com.meidusa.toolkit.net.config.ExceptionCodeConstant;
import com.meidusa.toolkit.util.TimeUtil;

public abstract class FrontendConnection extends AbstractConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontendConnection.class);

    protected String host;
    protected int port;
    protected int localPort;
    protected long idleTimeout;
    protected boolean isAccepted;
    

    public FrontendConnection(SocketChannel channel) {
        super(channel);
        Socket socket = channel.socket();
        this.host = socket.getInetAddress().getHostAddress();
        this.port = socket.getPort();
        this.localPort = socket.getLocalPort();
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getLocalPort() {
        return localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public long getIdleTimeout() {
        return idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public boolean isIdleTimeout() {
        return TimeUtil.currentTimeMillis() > Math.max(lastWriteTime, lastReadTime) + idleTimeout;
    }

    public void setAccepted(boolean isAccepted) {
        this.isAccepted = isAccepted;
    }

    @Override
    protected void idleCheck() {
        if (isIdleTimeout()) {
            LOGGER.warn(toString() + " idle timeout");
            close();
        }
    }

    @Override
    public void handle(final byte[] data) {
        // 异步处理前端数据
    	if(processor.getExecutor() != null){
    		Runnable runnable = new Runnable() {
                @Override
                public void run() {
                    try {
                        handler.handle(FrontendConnection.this,data);
                    } catch (Throwable t) {
                        handleError(ExceptionCodeConstant.ERR_HANDLE_DATA, t);
                    }
                }
            };
    		processor.getExecutor().execute(runnable);
    	}else{
    		try {
                handler.handle(FrontendConnection.this,data);
            } catch (Throwable t) {
                handleError(ExceptionCodeConstant.ERR_HANDLE_DATA, t);
            }
    	}
    }

    protected boolean isConnectionReset(Throwable t) {
        if (t instanceof IOException) {
            String msg = t.getMessage();
            return (msg != null && msg.contains("Connection reset by peer"));
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringBuilder().append("[thread=").append(Thread.currentThread().getName()).append(",class=")
                .append(getClass().getSimpleName()).append(",host=").append(host).append(",port=").append(port)
                .append(']').toString();
    }

}
