package com.meidusa.toolkit.net;

import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class AuthingableBackendConnection extends BackendConnection {
	private boolean isAuthenticated;
	private CountDownLatch countdown = new CountDownLatch(1);
	private MessageHandler responseMessageHandler;
	public AuthingableBackendConnection(SocketChannel channel) {
		super(channel);
	}

	public boolean isAuthenticated() {
        return isAuthenticated;
    }

    public void setAuthenticated(boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
        this.setHandler(responseMessageHandler);
        if(countdown.getCount()>0){
        	countdown.countDown();
        }
    }
    
    public boolean waitForAuthenticate(long timeout,TimeUnit unit){
    	if(this.isAuthenticated){
    		return true;
    	}
    	try {
			countdown.await(timeout, unit);
		} catch (InterruptedException e) {
		}
    	return isAuthenticated;
    }

	public MessageHandler getResponseMessageHandler() {
		return responseMessageHandler;
	}

	public void setResponseMessageHandler(MessageHandler responseMessageHandler) {
		this.responseMessageHandler = responseMessageHandler;
	}
	
	public boolean close() {
        boolean closed = super.close();
        if (closed) {
        	if(countdown.getCount()>0){
            	countdown.countDown();
            }
        }
        return closed;
    }
    
}
